<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slider;
use DB;
use Auth;
use App\Models\Division;
use App\Models\CityCorporation;
use App\Models\District;
use App\Models\User;
use Validator;
use App\Models\Order;
use App\Models\Support;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Mail;
use App\Models\PromoCode;
use App\Models\Paymentmethod;
use \DateTimeZone;
use App\Models\Userbank;
use App\Models\Withdrawrequest;
use App\Models\CancelOrder;
use App\Models\Brand;
class ApiController extends Controller
{
    public function sliders()
    {
        try
        {   
            $base_url = url('/');
            $sliders = Slider::select('id', DB::raw("CONCAT('$base_url/', sliders.image) AS image"))->latest()->get();
            if(count($sliders) > 0)
            {
                return response()->json(['status'=>true, 'message'=>'Data found', 'data'=>$sliders]);
            }
            return response()->json(['status'=>false, 'message'=>'No data found', 'data'=>$sliders]);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function userDetails()
    {
        try
        {
            if(Auth::user()->image == NULL)
            {
                $image = NULL;
            }
            else
            {
                $image = url('/').'/'.Auth::user()->image;
            }
            $data = ['id'=>Auth::user()->id, 'name'=>Auth::user()->name, 'email'=>Auth::user()->email, 'phone'=>Auth::user()->phone, 'address'=>Auth::user()->address, 'image'=>$image];
            return response()->json(['status'=>true, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function divisions()
    {
        try
        {
           $divisions = Division::select('id', 'name')->get();
           return response()->json(['status'=>true, 'data'=>$divisions]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function cities($district_id)
    {
        try
        {  
            $data = DB::table('cities')
                       ->join('thanas', 'cities.thana_id', 'thanas.id')
                       ->select('cities.id', 'thanas.thana as name')
                       ->where('cities.district_id',$district_id)
                       ->get();
            return response()->json(['status'=>true,'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function districts($division_id)
    {
        try
        {  
            $division = Division::find($division_id);
            $data = District::select('id', 'name')->where('division_id',$division_id)->get();

            return response()->json(['status'=>true,  'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function nearestDeliverymen(Request $request)
    {
        try
        {   

            $validator = Validator::make($request->all(), [
                'lat' => 'required',
                'lon' => 'required',
                'distance' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $lat = $request->lat;
            $lon = $request->lon;
            $distance = $request->distance;
            $data = User::select("users.lat", "users.lon"
                            ,DB::raw("6371 * acos(cos(radians(" . $lat . ")) 
                            * cos(radians(users.lat)) 
                            * cos(radians(users.lon) - radians(" . $lon . ")) 
                            + sin(radians(" .$lat. ")) 
                            * sin(radians(users.lat))) AS distance"))
                            ->where('users.role', 'develivery_man')
                            ->having('distance', '<=', $distance)
                            ->orderBy('distance', 'ASC')
                            ->get(); 
           if(count($data) > 0)
           {
              return response()->json(['status'=>true, 'message'=>'Data found', 'total'=>count($data), 'data'=>$data]);
           }
           return response()->json(['status'=>false, 'message'=>'No data found', 'total'=>count($data), 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function thanas($district_id)
    {
        try
        {   
            $district = DB::table('districts')->where('id',$district_id)->first();
            
            $data = DB::table('thanas')->select('id','thana')->where('district_id',$district_id)->groupBy('thana')->get();
            return response()->json(['status'=>true, 'total'=>count($data), 'district'=>$district->name, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }

    }

    public function checkOtp(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                 'otp' => 'required|string',
                 'user_id'=> 'required|integer'
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $check = DB::table('otps')->where('user_id',$request->user_id)->where('otp',$request->otp)->first();

            if($check)
            {
                DB::table('users')->where('id',$request->user_id)->update(['status'=>'Active']);
                return response()->json(['status'=>true, 'message'=>'Successfully verified']);
            }
            
            return response()->json(['status'=>false, 'message'=>'Invalid Otp']);


        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    

    public function createOrder(Request $request)
    {
        try
        {
            
            
            
            if(!empty($request->vendor_id))
            {
                $vendor_id = $request->vendor_id;
            }
            else
            {
                $vendor_id = NULL;
            }
            
            $order = new Order();
            $order->sender_id = Auth::user()->id;
            $order->vendor_id = $vendor_id;
            $order->place_type = $request->place_type;
            $order->receiver_name = $request->receiver_name;
            $order->receiver_phone = $request->receiver_phone;
            $order->division_id = $request->division_id;
            $order->district_id = $request->district_id;
            $order->thana_id = $request->thana_id;
            $order->full_address = $request->full_address;
            $order->weight = $request->weight;
            $order->item_type = $request->item_type;
            $order->pickup_lat = $request->pickup_lat;
            $order->pickup_lon = $request->pickup_lon;
            $order->guide = $request->guide;
            $order->courier_method = $request->courier_method;
            $order->payby = $request->payby;
            $order->paymentmethod_id = $request->paymentmethod_id;
            $order->total_price = $request->total_price;
            $order->date = date('Y-m-d');
            $order->time = date('h:i A');
            $order->month = date('F');
            $order->year = date('Y');
            $order->parcel_details = $request->parcel_details;
            $order->save();
            
            $get_order = Order::findorfail($order->id);
            
            $percentage = 20;
            $amount = ($percentage / 100) * $get_order->total_price;

            Order::where('id',$get_order->id)->update(['earning_price'=>$get_order->total_price - $amount]);
            
            
            return response()->json(['status'=>true, 'message'=>'Successfully order has been taken', 'order_id'=>$order->id]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function priceCalculation(Request $request)
    {
        try
        {   

            $validator = Validator::make($request->all(), [
                'sender_lat' => 'required',
                'sender_lon' => 'required',
                'pickup_lat' => 'required',
                'pickup_lon' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            } 

            $lon1 = $request->sender_lon;
            $lon2 = $request->pickup_lon;

            $lat1 = $request->sender_lat;
            $lat2 = $request->pickup_lat;

            $earthRadius = 6371; // km

            $dLat = deg2rad($lat2 - $lat1);
            $dLon = deg2rad($lon2 - $lon1);

            $a = sin($dLat / 2) * sin($dLat / 2) +
                cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
                sin($dLon / 2) * sin($dLon / 2);

            $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

            $distance = floor($earthRadius * $c);
            
            $get_distance = $earthRadius * $c;
            

            $base_url = url('/');
            $today = date('Y-m-d');
            $get_percantage = PromoCode::select('id', 'title', 'discount', DB::raw("CONCAT('$base_url/', promo_codes.image) AS image"), 'from_date', 'to_date')
                     ->whereDate('from_date', '<=', $today)
                     ->whereDate('to_date', '>=', $today)
                    ->orderBy('id','DESC')
                    ->first();
             

             
                    
            if($get_percantage)
            {   
                $percentage = $get_percantage->discount;
                $get_total = $distance*getPrice()->per_km + getPrice()->per_weight * $request->weight;
                $amount = ($percentage / 100) * $get_total;
                
                $homepickup_total = $get_total - $amount;
            }
            else
            {
                $homepickup_total = $distance*getPrice()->per_km + getPrice()->per_weight * $request->weight; 
            }


            $agent_total = $homepickup_total-20;
        
        
            
            
            User::where('id',Auth::user()->id)->where('role', 'user')->update(['lat'=>$request->sender_lat, 'lon'=>$request->sender_lon]);


            return response()->json(['status'=>true, 'distance'=>strval($get_distance), 'homepickup_total'=>floor($homepickup_total), 'agent_total'=>floor($agent_total)]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function orderUpdate(Request $request)
    {
        try
        {
           $validator = Validator::make($request->all(), [
                 'order_id'=> 'required|integer',
                 'deliverymen_id' => 'required|integer',
                 'status'  => 'required',
             ]);

              if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
           
           $order = Order::findorfail($request->order_id);
            
            if($request->status == 'accept')
            {
                if($order->status == 'accept')
                {
                    return response()->json(['status'=>false, 'order_id'=>intval($request->order_id), 'message'=>'Sorry alreay the order has been accepted by another deliverymen']);
                }
            }
             
            

            Order::where('id',$request->order_id)->update(['user_id'=>$request->deliverymen_id, 'status'=>$request->status]);

            $order = Order::find($request->order_id);

            

            if($order->status == 'delivered')
            {
                $percentage = 20;
                

                $amount = ($percentage / 100) * $order->total_price;



                User::where('id',$order->user_id)->update(['balance'=>ceil($order->total_price - $amount)+Auth::user()->balance]);
                $get_order = Order::findorfail($order->id);

                Order::where('id',$get_order->id)->update(['earning_price'=>$amount]);

            }

            return response()->json(['status'=>true, 'order_id'=>intval($request->order_id), 'message'=>'Successfully order has been updated']);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function vehicleTypes()
    {
        try
        {
            $data = DB::table('vehicle_types')->select('id','type')->get();
            return response()->json(['status'=>true, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function inboxes()
    {
        try
        {   
            $base_url = url('/');
            $data = DB::table('inboxes')->where('type','inbox')->select('id','title', \DB::raw("CONCAT('$base_url/', inboxes.image) AS image"), 'date_two as date','description')->orderBy('date','DESC')->get();
            return response()->json(['status'=>true, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function notifications()
    {
        try
        {
            $base_url = url('/');
            $data = DB::table('inboxes')->where('type','notification')->select('id','title', \DB::raw("CONCAT('$base_url/', inboxes.image) AS image"), 'date_two as date','description')->orderBy('date','DESC')->get();
            return response()->json(['status'=>true, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function support()
    {
        try
        {
            $data = Support::select('id','phone_one','phone_two','email')->find(1);
            return response()->json(['status'=>true, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function tripHistory()
    {
        try
        {
            $data = Order::join('users', 'orders.sender_id', 'users.id')
                        ->join('divisions', 'orders.division_id', 'divisions.id')
                        ->join('districts', 'orders.district_id', 'districts.id')
                        ->join('thanas', 'orders.thana_id', 'thanas.id')
                        ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                       ->select('users.name as sender', 'orders.place_type', 'orders.receiver_name', 'orders.receiver_phone', 'divisions.name as division', 'districts.name as district', 'thanas.thana as city', 'orders.full_address', 'orders.weight', 'orders.item_type', 'orders.pickup_lat', 'orders.pickup_lon', 'orders.guide', 'orders.courier_method', 'orders.payby', 'paymentmethods.name as payment_method', 'orders.total_price', 'orders.status', 'orders.date', 'orders.time', 'orders.earning_price')
                       ->where('orders.user_id',Auth::user()->id)
                       ->orderBy('orders.id', 'DESC')
                       ->get();
            return response()->json(['status'=>true, 'message'=>'Data found', 'total'=>count($data), 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function allWeek($id)
    {
        try
        { 

 
                $year = date('Y');

                $startOfYear = Carbon::createFromDate($year, 1, 1); 
                $endOfYear = Carbon::createFromDate($year, 12, 31); 

                $arrs = [];

                for ($date = $startOfYear->copy()->startOfWeek(); $date->lte($endOfYear); $date->addWeek()) {
                    $weekNumber = $date->weekOfYear;
                   
 
                    $total_price = DB::table('orders')->where('orders.date','>=', $date->format('Y-m-d'))->where('orders.date', '<=', $date->copy()->endOfWeek()->format('Y-m-d'))->where('user_id',$id)->sum('total_price');

                    $percentage = 20;
                

                   $amount = ($percentage / 100) * $total_price;



                    $arrs[] = ['from_date'=>$date->format('Y-m-d'), 'to_data'=>$date->copy()->endOfWeek()->format('Y-m-d'), 'start_date'=>$date->format('M d'), 'end_date'=>$date->copy()->endOfWeek()->format('M d'),  'total_price'=>intval($total_price)-$amount];
                }
            

          
            $data = array();
            foreach($arrs as $row)
            {   

                $start_date = Carbon::parse($row['from_date']);
                $end_date = Carbon::parse($row['to_data']);
                  $days = array();
                  for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
                    $days[] = ['day'=>intval($date->format('d'))];
                }

          

                $data[] = ['from_date'=>$row['from_date'], 'to_date'=>$row['to_data'], 'start_date'=>$row['start_date'], 'end_date'=>$row['end_date'], 'total_price'=>$row['total_price'], 'days'=>$days];
            }        

           return response()->json(['status'=>true, 'data'=>$data]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    public function orderBydate(Request $request)
    {
        try
        {
             $validator = Validator::make($request->all(), [
                 'date'=> 'required',
                 
             ]);

              if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $total_price = DB::table('orders')->where('date',$request->date)->where('user_id',Auth::user()->id)->sum('total_price');

            $percentage = 20;
                

            $amount = ($percentage / 100) * $total_price;

            return response()->json(['status'=>true, 'total_price'=>intval($total_price-$amount)]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function weekDetails(Request $request)
    {
        try
        {   
    

            $validator = Validator::make($request->all(), [
                 'from_date'=> 'required',
                 'to_date' => 'required',
                 
             ]);

              if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $percentage = 20;

            $date_range = [];
            $start_date = Carbon::parse($request->from_date);
            $end_date = Carbon::parse($request->to_date);

            for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
                $date_ranges[] = ['date'=>$date->format('Y-m-d')];
            }

            $data = array();

            foreach($date_ranges as $row)
            {   
                $total = Order::where('date',$row['date'])->where('user_id',Auth::user()->id)->sum('total_price');
                $get_amount = ($percentage / 100) * $total;
                $data[] = ['date'=>$row['date'], 'total'=>intval($total) - $get_amount, 'net_fare'=>intval($total), 'tax'=>"20%",];
            }

      

            $total_price = DB::table('orders')->where('orders.date','>=', $request->from_date)->where('orders.date', '<=', $request->to_date)->where('user_id',Auth::user()->id)->sum('total_price');

                    
                

                   $amount = ($percentage / 100) * $total_price;

                  
                  return response()->json(['status'=>true, 'total_price'=>intval($total_price)-$amount,  'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function totalDue()
    {
        try
        {
            $total = Order::where('user_id',Auth::user()->id)->sum('total_price');

            $total_due = $total - Auth::user()->balance;

            return response()->json(['status'=>true, 'total_due'=>$total_due]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
   
   public function deliverymenStatus(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'status' => 'required',
                'user_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            User::where('id',$request->user_id)->update(['online'=>$request->status]);

            return response()->json(['status'=>true, 'message'=>'User status has been updated']);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function sendPush(Request $request)
    {
        try
        {    

            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $order = Order::findorfail($request->order_id);
            
            if($order->status == 'cancel' || $order->status == 'pending')
            {
                $lat = $order->receiver_lat;
                $lon = $order->receiver_lon;

                $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token"
                                ,DB::raw("6371 * acos(cos(radians(" . $lat . ")) 
                                * cos(radians(users.lat)) 
                                * cos(radians(users.lon) - radians(" . $lon . ")) 
                                + sin(radians(" .$lat. ")) 
                                * sin(radians(users.lat))) AS distance"))
                                ->where('users.role', 'delivery_men')
                                ->where('users.device_token', '!=', NULL)
                                ->where('users.online', 'yes')
                                ->orderBy('distance', 'ASC')
                                ->limit(1)
                                ->pluck('device_token')
                                ->all();

                                
                
                
                // FCM endpoint
                $endpoint = 'https://fcm.googleapis.com/fcm/send';
                
                // Server key obtained from Firebase Console
                $serverKey = getFirebase()->app_key;
                
                // Array of device tokens
                $deviceTokens = $firebaseToken;

                $payload = [

                  'data' => [
                     'title' => 'Courier Delivery',
                    'body' => 'New Order Request',
                    "click_action"=> "MAIN_ACTIVITY",
                    'notification_id' => intval($request->order_id)
                  ],
                  'registration_ids' => $firebaseToken
                ];
                
                $headers = [
                  'Authorization: key=' . $serverKey,
                  'Content-Type: application/json'
                ];
                
                $ch = curl_init($endpoint);
                
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                
                $response = curl_exec($ch);

                curl_close($ch);
                
            
                
                return response()->json(['status'=>true, 'order_id'=>intval($request->order_id), 'message'=>'Successfully notification send to all deliverymen']);
            }
            else{
                return response()->json(['status'=>false, 'order_id'=>intval($request->order_id), 'message'=>'Sorry the order is proccessing by others deliverymen']);
            }    
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

     public function orderDetails($id)
    {
        try
        {
           $base_url = url('/');
           $get_order = Order::findorfail($id);
           $user = User::findorfail($get_order->sender_id);
           

           $lon1 = $user->lon;
            $lon2 = $get_order->pickup_lon;

            $lat1 = $user->lat;
            $lat2 = $get_order->pickup_lat;

            $earthRadius = 6371; // km

            $dLat = deg2rad($lat2 - $lat1);
            $dLon = deg2rad($lon2 - $lon1);

            $a = sin($dLat / 2) * sin($dLat / 2) +
                cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
                sin($dLon / 2) * sin($dLon / 2);

            $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

            $distance_result = floor($earthRadius * $c);

            //return response()->json($distance);
            
            $total_review = DB::table('reviews')->where('user_id',$user->id)->where('review_taker', 'delivery_men')->sum('total_star');
                
                $count_review = DB::table('reviews')->where('user_id',$user->id)->where('review_taker', 'delivery_men')->count();
                
                if($count_review == 0 || $total_review == 0)
                {
                    $review = "0";
                }
                else
                {
                    $review = number_format($total_review/$count_review, 1);
                }
                
              
              

           $order = Order::join('users', 'orders.sender_id', 'users.id')
                          ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                           ->selectRaw("{$distance_result} AS distance, {$review} AS review")
                          ->select('orders.id', 'users.id as sender_id', 'users.name as sender_name', 'users.email as sender_email', 'users.phone as sender_phone', 'users.lat as sender_lat', 'users.lon as sender_lon', 'orders.receiver_name', 'orders.receiver_phone', 'orders.item_type', 'orders.weight', 'orders.pickup_lat', 'orders.pickup_lon', 'orders.guide', 
                            'orders.parcel_details', 'orders.courier_method', 'orders.payby', 'paymentmethods.name as payment_method', 'orders.total_price', 'orders.earning_price', 'orders.date', 'orders.time' , \DB::raw("CONCAT('$base_url/', users.image) AS sender_image"), DB::raw("$distance_result as distance"), DB::raw("$review as review"))
                     ->where('orders.id',$id)
                     ->first();
           
           return response()->json(['status'=>true, 'data'=>$order]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function updateDeviceToken(Request $request)
    {
        try
        {  
            
            $validator = Validator::make($request->all(), [
                'token' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $user = User::where('id',Auth::user()->id)->first();

            if($user)
            {
                User::where('id',Auth::user()->id)->update(['device_token'=>$request->token]);
            }
            
            

            return response()->json(['status'=>true, 'message'=>'Device token updated']);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function sendUserPush(Request $request)
    {
        try
        {
             $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $order = Order::findorfail($request->order_id);



            $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token")
                            ->where('users.id', $order->sender_id)
                            ->pluck('device_token')
                            ->all();
                            
        
           
           // FCM endpoint
            $endpoint = 'https://fcm.googleapis.com/fcm/send';
            
            // Server key obtained from Firebase Console
            $serverKey = getFirebase()->app_key;
            
            // Array of device tokens
            $deviceTokens = $firebaseToken;
            
            // Notification payload
            $payload = [
              'notification' => [
                'title' => 'Courier Delivery',
                'body' => 'New Order Request',
                "click_action"=> "MAIN_ACTIVITY"
              ],
              'data' => [
                'notification_id' => intval($request->order_id)
              ],
              'registration_ids' => $firebaseToken
            ];
            
            // Set headers
            $headers = [
              'Authorization: key=' . $serverKey,
              'Content-Type: application/json'
            ];
            
            // Initialize cURL
            $ch = curl_init($endpoint);
            
            // Set cURL options
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            
            // Execute cURL request
            $response = curl_exec($ch);
            
            // Close cURL
            curl_close($ch);
            return response()->json(['status'=>true, 'order_id'=>intval($request->order_id), 'message'=>'Successfully notification send to sender']);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function deliverymenInfo($user_id)
    {
        try
        {   
            $base_url = url('/');
            $data = DB::table('users')
                        ->join('deliveryvehicles', 'users.id', 'deliveryvehicles.user_id')
                        ->select('users.id', 'users.name', 'users.phone', 'users.email', 'users.lat', 'users.lon', \DB::raw("CONCAT('$base_url/', users.image) AS image"), 'deliveryvehicles.type', 'deliveryvehicles.model', 'deliveryvehicles.brand', 'deliveryvehicles.reg_no', 'deliveryvehicles.year', 'deliveryvehicles.tax_token_no', 'deliveryvehicles.fitness_number')
                        
                        ->where('users.id',$user_id)
                        
                        ->first();
                        
         $total_trips = DB::table('orders')->where('user_id',$user_id)->where('status', 'delivered')->count();
         
         return response()->json(['status'=>true, 'total_trips'=>$total_trips, 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function vendorLists(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'lat' => 'required',
                'lon' => 'required',
                'distance' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $base_url = url('/');
            $lat = $request->lat;
            $lon = $request->lon;
            $distance = $request->distance;
            $data = User::select("users.id", "users.name", "users.phone", "users.email", "users.lat", "users.lon", \DB::raw("CONCAT('$base_url/', users.image) AS image")
                            ,DB::raw("6371 * acos(cos(radians(" . $lat . ")) 
                            * cos(radians(users.lat)) 
                            * cos(radians(users.lon) - radians(" . $lon . ")) 
                            + sin(radians(" .$lat. ")) 
                            * sin(radians(users.lat))) AS distance"))
                            ->where('users.role', 'vendor')
                            ->having('distance', '<=', $distance)
                            ->orderBy('distance', 'ASC')
                            ->get(); 
           if(count($data) > 0)
           {
              return response()->json(['status'=>true, 'message'=>'Data found', 'total'=>count($data), 'data'=>$data]);
           }
           return response()->json(['status'=>false, 'message'=>'No data found', 'total'=>count($data), 'data'=>$data]);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function vendorUpdate(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'vendor_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            DB::table('orders')->where('id',$request->order_id)->update(['vendor_id'=>$request->vendor_id]);
            
            return response()->json(['status'=>true, 'message'=>'Your order has been proceed, Thanks']);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
   
   
   public function review(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'user_id' => 'required|integer',
                'deliverymen_id' => 'required|integer',
                'total_star' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $check = DB::table('reviews')->where('id', $request->order_id)->first();
            if($check)
            {
                return response()->json(['status'=>false, 'message'=>'Already review has been taken']);
            }
            
            if(!empty($request->behave))
            {
                $behave = $request->behave;
            }
            else
            {
                $behave = NULL;
            }
            
            if(!empty($request->communication))
            {
                $communication = $request->communication;
            }
            else
            {
                $communication = NULL;
            }
            
            $data = array();
            $data['order_id'] = $request->order_id;
            $data['user_id'] = $request->user_id;
            $data['deliverymen_id'] = $request->deliverymen_id;
            $data['total_star'] = $request->total_star;
            $data['review_text'] = $request->review_text;
            $data['review_taker'] = Auth::user()->role;
            $data['behave'] = $request->behave;
            $data['communication'] = $request->communication;
            DB::table('reviews')->insert($data);
            
            return response()->json(['status'=>true, 'message'=>'Successfully review has been added']);
            
            
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function myReviews()
   {
       try
       {  
          $base_url = url('/');
          if(Auth::user()->role == 'delivery_men')
          {  
             
              $data = DB::table('reviews')
                      ->join('users', 'reviews.user_id', 'users.id')
                      ->select('reviews.*', 'users.name as user_name', \DB::raw("CONCAT('$base_url/', users.image) AS image"))
                      ->where('reviews.review_taker','user')
                      ->orderBy('reviews.id','DESC')
                      ->get();
          }else
          {
              $data = DB::table('reviews')
                      ->join('users', 'reviews.deliverymen_id', 'users.id')
                      ->select('reviews.*', 'users.name as user_name', \DB::raw("CONCAT('$base_url/', users.image) AS image"))
                      ->where('reviews.review_taker','delivery_men')
                      ->orderBy('reviews.id','DESC')
                      ->get();
          }
          
          if(count($data) > 0)
          {
              return response()->json(['status'=>true, 'message'=>'Data found', 'total'=>count($data), 'data'=>$data]);
          }
          return response()->json(['status'=>false, 'message'=>'No data found', 'total'=>count($data), 'data'=>$data]);  
          
           
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function storeChat(Request $request)
   {
       try
       {   
           
           
           
           $validator = Validator::make($request->all(), [
                'user_id' => 'required|integer',
                'deliverymen_id' => 'required|integer',
                'message' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
           $data = array();
           $data['user_id'] = $request->user_id;
           $data['deliverymen_id'] = $request->deliverymen_id;
           $data['message'] = $request->message;
           $data['date'] = date('Y-m-d');
           $data['time'] = date('h:i:s A');
           $data['who'] = Auth::user()->role;
           
           DB::table('chats')->insert($data);
           
           return response()->json(['status'=>true, 'message'=>'Chat added', 'user_id'=>intval($request->user_id), 'deliverymen_id'=>intval($request->deliverymen_id)]);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function chatLists(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                'user_id' => 'required|integer',
                'deliverymen_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $data = DB::table('chats')->where('user_id',$request->user_id)->where('deliverymen_id',$request->deliverymen_id)->orderBy('id', 'ASC')->get();
            
            if(count($data) > 0)
            {
                return response()->json(['status'=>true, 'message'=>'Data found', 'data'=>$data]);
            }
            return response()->json(['status'=>false, 'message'=>'No data found', 'data'=>$data]);
            
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function userProfileEdit(Request $request)
   {
       try
       {  
           $user = User::find(Auth::user()->id);
           $validator = Validator::make($request->all(), [
                'name' => 'required|string',
                'phone' => 'required|string',
                'email' => 'required|string',
                'address' => 'required',
                
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
             if($request->file('image'))
              {   
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/users/', $name); 
                $path = 'public/uploads/users/'.$name;
              }
              else
              {
                  $path = $user->image;
              }
              
              
              $user->name = $request->name;
              $user->phone = $request->phone;
              $user->email = $request->email;
              $user->address = $request->address;
              $user->image = $path;
              $user->update();
              
              return response()->json(['status'=>true, 'message'=>'Profile Updated']);
          
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function changePassword(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'old_password' => 'required|string',
                 'new_password' => 'required|string',
                 'confirm_password' => 'required|string',
              ]);
              if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
             }
             
             if(!Hash::check($request->old_password, auth()->user()->password)){
                return response()->json(['status'=>false, 'message'=>'Password is not matched'], 200);
            }
            
            if($request->new_password != $request->confirm_password)
            {
                return response()->json(['status'=>false, 'message'=>'Not matched'], 200);
            }
    
            User::whereId(auth()->user()->id)->update([
                'password' => Hash::make($request->new_password)
            ]);
             return response()->json(['status'=>true, 'message'=>'Your password has been changed']);
             
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function resendOtp(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'email' => 'required|string',
              ]);
              if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
             }
             $otp = rand(1231,7879);
             $mail_data = array('name'=>"OTP", "to_address"=>$request->email, 'subject'=>'OTP', 'body'=>$otp, 'title'=>'OTP', 'from_address'=>env('MAIL_USERNAME')); 
                  Mail::send('otp', $mail_data, function($message) use ($mail_data) {
                     $message->to($mail_data['to_address'], '')->subject
                        ($mail_data['subject']);
                     $message->from($mail_data['from_address'],'');
                  });

        return ['status'=>true, 'message'=>'Please check your email inbox or spam to get otp'];
             
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function recentOrders()
   {
       try
       {
           $data = DB::table('orders')
                     ->where('sender_id', Auth::user()->id)
                     ->orderBy('id', 'DESC')
                     ->limit(3)
                     ->get();
                     
         if(count($data) > 0)
         {
             return response()->json(['status'=>true, 'message'=>'Data found', 'data'=>$data]);
         }
         return response()->json(['status'=>false, 'message'=>'No data found', 'data'=>$data]);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function forgotPassword(Request $request)
   {
       try
       {
            $validator = Validator::make($request->all(), [
                 'email' => 'required|string',
              ]);
              if($validator->fails()){
                return response()->json(['status'=>false, 'message'=>'The given data was Invalid', 'errors'=>$validator->errors()]);  
             }
             
             $user = DB::table('users')->where('email',$request->email)->first();
             
             if(!$user)
             {
                 return response()->json(['status'=>false, 'message'=>'Invalid Email']);
             }
             
             $otp = rand(1231,7879);
             
             $values = array(); 
        $values['user_id'] = $user->id;
        $values['otp'] = $otp;

        DB::table('otps')->insert($values);
        
             $mail_data = array('name'=>"OTP", "to_address"=>$request->email, 'subject'=>'OTP', 'body'=>$otp, 'title'=>'OTP', 'from_address'=>env('MAIL_USERNAME')); 
                  Mail::send('otp', $mail_data, function($message) use ($mail_data) {
                     $message->to($mail_data['to_address'], '')->subject
                        ($mail_data['subject']);
                     $message->from($mail_data['from_address'],'');
                  });

        return ['status'=>true, 'message'=>'Please check your email inbox or spam to get otp'];
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function resetOtp(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'otp' => 'required|string',
                 'email'=> 'required|string'
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $user = User::where('email',$request->email)->first();

            $check = DB::table('otps')->where('user_id',$user->id)->where('otp',$request->otp)->first();

            if($check)
            {
                
                return response()->json(['status'=>true, 'message'=>'Successfully verified']);
            }
            
            return response()->json(['status'=>false, 'message'=>'Invalid Otp']);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function resetPassword(Request $request)
   {   
       try
       {   
           
            $validator = Validator::make($request->all(), [
                 'email'=> 'required|string',
                 'new_password' => 'required|string',
                 'confirm_password' => 'required|string',
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
             
           if($request->new_password != $request->confirm_password)
            {
                return response()->json(['status'=>false, 'message'=>'Not matched'], 200);
            }
            
            $user = User::where('email',$request->email)->first();
            
            User::where('id',$user->id)->update(['password'=>bcrypt($request->new_password)]);
            
            return response()->json(['status'=>true, 'message'=>'Password has been updated']);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
       
   }
   
   public function getOrderDetails(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'order_id'=> 'required|integer',
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            

            
            $base_url = url('/');
            
            $order = Order::findorfail($request->order_id);
            

            
            $user = User::findorfail($order->user_id);
            
            $total_trip = Order::where('user_id',$user->id)->count();
            
            $vehicle = DB::table('deliveryvehicles')->select('id', 'type', 'brand', 'model', 'reg_no', 'year', 'tax_token_no', 'fitness_number')->where('deliveryvehicles.user_id',$user->id)->first();
            
            $get_user = User::findorfail($order->sender_id);
            
            $lon1 = $get_user->lon;
            $lon2 = $order->pickup_lon;

            $lat1 = $get_user->lat;
            $lat2 = $order->pickup_lat;

            $earthRadius = 6371; // km

            $dLat = deg2rad($lat2 - $lat1);
            $dLon = deg2rad($lon2 - $lon1);

            $a = sin($dLat / 2) * sin($dLat / 2) +
                cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
                sin($dLon / 2) * sin($dLon / 2);

            $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

            $distance_result = intval(floor($earthRadius * $c));
            
               
            
            $get_distance = $earthRadius * $c;
    
            
            
              $total_trip = Order::where('user_id',$user->id)->count();   
              
              $total_review = DB::table('reviews')->where('deliverymen_id',$user->id)->where('review_taker', 'user')->sum('total_star');
                
               
                
                $count_review = DB::table('reviews')->where('deliverymen_id',$user->id)->where('review_taker', 'user')->count();
                
                if($count_review == 0 || $total_review == 0)
                {
                    $review = "0";
                }
                else
                {
                    $review = number_format($total_review/$count_review, 1);
                }
                
                
            
           $data = Order::join('users', 'orders.user_id', 'users.id')
                          ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                          ->selectRaw("{$distance_result} AS distance, {$review} AS review")
                          ->select('orders.id', 'orders.user_id as deliverymen_id', 'orders.sender_id as user_id', 'users.name as deliverymen_name', 'users.email as deliverymen_email', 'users.phone as deliverymen_phone', 'users.lat as deliverymen_lat', 'users.lon as deliverymen_lon', 'orders.receiver_name', 'orders.receiver_phone', 'orders.item_type', 'orders.weight', 'orders.pickup_lat', 'orders.pickup_lon', 'orders.guide', 
                            'orders.parcel_details', 'orders.courier_method', 'orders.payby', 'paymentmethods.name as payment_method', 'orders.total_price', 'orders.earning_price', 'orders.date', 'orders.time' , \DB::raw("CONCAT('$base_url/', users.image) AS sender_image"), DB::raw("$distance_result as distance"), DB::raw("$review as review"), 'orders.full_address')
                     ->where('orders.id',$request->order_id)
                     ->first();
        
         return response()->json(['status'=>true, 'total_trip'=>$total_trip, 'vehicle'=>$vehicle, 'data'=>$data]);
            
            
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   
   public function getOrderStatus(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'order_id'=> 'required|integer',
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $data = Order::select('id', 'sender_id', 'user_id as deliverymen_id', 'status')->findorfail($request->order_id);
            
            return response()->json(['status'=>true, 'data'=>$data]);
            
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function promocodes()
   {
       try
       {
           $base_url = url('/');
           
          
           $data = PromoCode::select('id', 'title', 'discount', DB::raw("CONCAT('$base_url/', promo_codes.image) AS image"), 'from_date', 'to_date')
                      ->orderBy('id', 'DESC')
                      ->limit(5)
                      ->get();
           if(count($data) > 0)
           {
               return response()->json(['status'=>true, 'message'=>'Data found', 'data'=>$data]);
           }
           return response()->json(['status'=>false, 'message'=>'No data found', 'data'=>$data]);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   
   public function updateAddress(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                 'address'=> 'required',
             ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            User::where('id',Auth::user()->id)->update(['address'=>$request->address]);
            
            return response()->json(['status'=>true, 'message'=>'Successfully address updated']);
            
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function deliveryProfileUpdate(Request $request)
   {
       try
       {   
           $user = User::findorfail(Auth::user()->id);
           
           $validator = Validator::make($request->all(), [
                'name' => 'required|string',
                'phone' => 'required|string',
                'email' => 'required|string',
                'address' => 'required',
                
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
             if($request->file('image'))
              {   
                $file = $request->file('image');
                $name = time().$file->getClientOriginalName();
                $file->move(public_path().'/uploads/users/', $name); 
                $path = 'public/uploads/users/'.$name;
              }
              else
              {
                  $path = $user->image;
              }
              
              $user->name = $request->name;
              $user->email = $request->email;
              $user->phone = $request->phone;
              $user->image = $path;
              $user->address = $request->address;
              $user->update();
              
              return response()->json(['status'=>true, 'message'=>'Profile Updated']);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function vehicleUpdate(Request $request)
   {
       try
       {
           $user = User::findorfail(Auth::user()->id);
           
           $validator = Validator::make($request->all(), [
                'type' => 'required|string',
                'brand' => 'required|string',
                'model' => 'required|string',
                'reg_no' => 'required|string',
                'year' => 'required|string',
                
                'tax_token_no' => 'required|string',
                
                'fitness_number' => 'required|string',
                
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            
            $data = array();
            $data['type'] = $request->type;
            $data['brand'] = $request->brand;
            $data['model'] = $request->model;
            $data['reg_no'] = $request->reg_no;
            $data['year'] = $request->year;
            $data['tax_token_no'] = $request->tax_token_no;
            $data['fitness_number'] = $request->fitness_number;
            
            DB::table('deliveryvehicles')->where('user_id',$user->id)->update($data);
            
            return response()->json(['status'=>true, 'message'=>'Vehicle Info Updated']);
            
           
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   public function checkDate(Request $request)
   {    
       $invest_start_date = "2017-06-02";
        $to = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d', strtotime($invest_start_date)));
        $from = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d', strtotime(\Carbon\Carbon::now())));
        $diff_in_months = $to->diffInMonths($from);

        return $diff_in_months;
   }

   public function setPaymentGateway(Request $request)
   {
       try
       {
           $validator = Validator::make($request->all(), [
                'payment_gateway_id' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $paymentGateway = Paymentmethod::findorfail($request->payment_gateway_id);

            if($request->payment_gateway_id == 2)
            {
                Stripe::setApiKey(env("STRIPE_SECRET"));

                    $token = Token::create([
                    'card' => [
                        'number' => $request->card_number,
                        'exp_month' => 12,
                        'exp_year' => 2024,
                        'cvc' => '123',
                        'address_zip' => '1361',
                    ],
                ]);

                $stripeToken = $token->id;

               

                Charge::create ([
                            "amount" => 100 * 10,
                            "currency" => "usd",
                            "source" => $stripeToken,
                            "description" => "Test payment from application" 
                    ]);


                return response()->json(['status'=>true, 'message'=>'Successfully payment has been taken']);
            }
            

       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   
   public function paymentMethodLists()
   {
       try
       {   
           
           $base_url = url('/');
           
           $data = DB::table('paymentmethods')->select('id', 'name', 'api_key', 'api_secret', DB::raw("CONCAT('$base_url/', paymentmethods.image) AS image"))->where('paymentmethods.status', 'Active')->where('id', '!=', 4)->get();
           return response()->json(['status'=>true, 'data'=>$data]);
       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }
   
   
   public function gettimeZones()
   {
       try
       {
           $timezones = timezones();
           return response()->json($timezones);

       }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
   }


   public function pickupStatusstore(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'status_value' => 'required|string',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $order = Order::findorfail($request->order_id);
            
            Order::where('id',$order->id)->update(['is_pickup'=>$request->status_value]);
            
            if($request->status_value == 'yes')
            {
                return response()->json(['status'=>true, 'message'=>'Successfully pick up the order']);
            }
            
            return response()->json(['status'=>false, 'message'=>'Order is not pick up']);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function collectStatusstore(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'status_value' => 'required|string',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $order = Order::findorfail($request->order_id);
            
            Order::where('id',$order->id)->update(['is_collectpay'=>$request->status_value]);
            
            if($request->status_value == 'yes')
            {
                return response()->json(['status'=>true, 'message'=>'Successfully collect pay for the order']);
            }
            
            return response()->json(['status'=>false, 'message'=>'Payment is not collected']);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    public function getCheckstatus(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $order = Order::findorfail($request->order_id);
            
            return response()->json(['status'=>true, 'is_pickup'=>$order->is_pickup, 'is_collectpay'=>$order->is_collectpay]);
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function completeOrder(Request $request)
    {
        try
        {   
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            $order = Order::findorfail($request->order_id);
            
            if($order->status == 'delivered')
            {
                $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token")
                            ->where('users.id', $order->sender_id)
                            ->where('users.online', 'yes')
                            ->pluck('device_token')
                            ->all();
                            
        
           
               // FCM endpoint
                $endpoint = 'https://fcm.googleapis.com/fcm/send';
                
                // Server key obtained from Firebase Console
                $serverKey = getFirebase()->app_key;
                
                // Array of device tokens
                $deviceTokens = $firebaseToken;
                
                // Notification payload
                $payload = [
                  'notification' => [
                    'title' => 'Order completed',
                    'body' => 'Order completed',
                    "click_action"=> "MAIN_ACTIVITY"
                  ],
                  'data' => [
                    'notification_id' => intval($request->order_id)
                  ],
                  'registration_ids' => $firebaseToken
                ];
                
                // Set headers
                $headers = [
                  'Authorization: key=' . $serverKey,
                  'Content-Type: application/json'
                ];
                
                // Initialize cURL
                $ch = curl_init($endpoint);
                
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                
                // Execute cURL request
                $response = curl_exec($ch);
                
                // Close cURL
                curl_close($ch);
                
               return response()->json(['status'=>true, 'message'=>'Successfully order has been delivered']);
            }
            
            return response()->json(['status'=>false, 'message'=>'Incomplete order']);
            
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


     public function getTotalbalance()
    {
        try
        {
            if(Auth::user()->role != 'delivery_men')
            {
                return response()->json(['status'=>false, 'balance'=>Auth::user()->balance]);
            }
            return response()->json(['status'=>true, 'balance'=>Auth::user()->balance]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function addUserbank(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'bank_name' => 'required|string',
                'acc_holder_name' => 'required|string',
                'branch_name'  => 'required|string',
                'account_number'  => 'required|string',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $userbank = new Userbank();
            $userbank->user_id = Auth::user()->id;
            $userbank->bank_name = $request->bank_name;
            $userbank->acc_holder_name = $request->acc_holder_name;
            $userbank->branch_name = $request->branch_name;
            $userbank->account_number = $request->account_number;
            $userbank->save();

            return response()->json(['status'=>true, 'message'=>'Successfully bank has been added']);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function userBanklists()
    {
        try
        {
            $data = Userbank::select('id', 'bank_name', 'acc_holder_name', 'branch_name', 'account_number')->where('user_id',Auth::user()->id)->get();
            if(count($data) > 0)
            {
                return response()->json(['status'=>true, 'total'=>count($data), 'message'=>'Data found', 'data'=>$data]);
            }
            return response()->json(['status'=>false, 'total'=>count($data), 'message'=>'No data found', 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function addWithdrawrequest(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'bank_id' => 'required|integer',
                'amount' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $withdraw = new Withdrawrequest();
            $withdraw->user_id = Auth::user()->id;
            $withdraw->bank_id = $request->bank_id;
            $withdraw->amount = $request->amount;
            $withdraw->status = 'Pending';
            $withdraw->date = date('Y-m-d');
            $withdraw->time = date('h:i:s A');
            $withdraw->save();

            User::where('id',Auth::user()->id)->update(['balance'=>0]);

            return response()->json(['status'=>true, 'message'=>'Successfully withdraw request has been added']);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function userWithdrawlists()
    {
        try
        {
            $data = Withdrawrequest::latest()->get();
             if(count($data) > 0)
            {
                return response()->json(['status'=>true, 'total'=>count($data), 'message'=>'Data found', 'data'=>$data]);
            }
            return response()->json(['status'=>false, 'total'=>count($data), 'message'=>'No data found', 'data'=>$data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function editUserbank(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'bank_id' => 'required|integer',
                'bank_name' => 'required|string',
                'acc_holder_name' => 'required|string',
                'branch_name'  => 'required|string',
                'account_number'  => 'required|string',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $userbank = Userbank::findorfail($request->bank_id);
            $userbank->user_id = Auth::user()->id;
            $userbank->bank_name = $request->bank_name;
            $userbank->acc_holder_name = $request->acc_holder_name;
            $userbank->branch_name = $request->branch_name;
            $userbank->account_number = $request->account_number;
            $userbank->update();

            return response()->json(['status'=>true, 'message'=>'Bank info has been updated']);
        }
        catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function bankDetails(Request $request)
    {
        try
        {   
            $validator = Validator::make($request->all(), [
                'bank_id' => 'required|integer',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }

            $userbank = Userbank::findorfail($request->bank_id);
            return response()->json(['status'=>true, 'data'=>$userbank]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function collectNotification(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'type' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $order = Order::findorfail($request->order_id);
            
            $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token")
                            ->where('users.id', $order->sender_id)
                            ->pluck('device_token')
                            ->all();
                            
           
               // FCM endpoint
                $endpoint = 'https://fcm.googleapis.com/fcm/send';
                
                // Server key obtained from Firebase Console
                $serverKey = getFirebase()->app_key;
                
                // Array of device tokens
                $deviceTokens = $firebaseToken;
                
                // Notification payload
                $payload = [
                  'notification' => [
                    'title' => $request->type,
                    'body' => $request->type,
                    "click_action"=> "MAIN_ACTIVITY"
                  ],
                  'data' => [
                    'notification_id' => intval($request->order_id)
                  ],
                  'registration_ids' => $firebaseToken
                ];
                
                // Set headers
                $headers = [
                  'Authorization: key=' . $serverKey,
                  'Content-Type: application/json'
                ];
                
                // Initialize cURL
                $ch = curl_init($endpoint);
                
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                
                // Execute cURL request
                $response = curl_exec($ch);
                
                // Close cURL
                curl_close($ch);
                
                
                
               return response()->json(['status'=>true, 'message'=>'Successfully sent']);
               
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function collectNotificationuser(Request $request)
    {
        try
        {
            $validator = Validator::make($request->all(), [
                'order_id' => 'required|integer',
                'type' => 'required',
            ]);

            if($validator->fails()){
                return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
            }
            
            $order = Order::findorfail($request->order_id);
            
            $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token")
                            ->where('users.id', $order->user_id)
                            ->where('users.online', 'yes')
                            ->pluck('device_token')
                            ->all();
                            
           
               // FCM endpoint
                $endpoint = 'https://fcm.googleapis.com/fcm/send';
                
                // Server key obtained from Firebase Console
                $serverKey = getFirebase()->app_key;
                
                // Array of device tokens
                $deviceTokens = $firebaseToken;
                
                // Notification payload
                $payload = [
                  'notification' => [
                    'title' => $request->type,
                    'body' => $request->type,
                    "click_action"=> "MAIN_ACTIVITY"
                  ],
                  'data' => [
                    'notification_id' => intval($request->order_id)
                  ],
                  'registration_ids' => $firebaseToken
                ];
                
                // Set headers
                $headers = [
                  'Authorization: key=' . $serverKey,
                  'Content-Type: application/json'
                ];
                
                // Initialize cURL
                $ch = curl_init($endpoint);
                
                // Set cURL options
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                
                // Execute cURL request
                $response = curl_exec($ch);
                
                // Close cURL
                curl_close($ch);
                
                
                
               return response()->json(['status'=>true, 'message'=>'Successfully sent']);
               
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

       public function updatePaymentmethod(Request $request)
       {
           try
           {
               $validator = Validator::make($request->all(), [
                    'order_id' => 'required|integer',
                    'paymentmethod_id' => 'required|integer',
                ]);

                if($validator->fails()){
                    return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
                }
                    
                $order = Order::findorfail($request->order_id);
                $order->paymentmethod_id = $request->paymentmethod_id;
                $order->update();
                
                return response(['status'=>true, 'message'=>'Successfully payment method has been updated']);
                
           }catch(Exception $e){
                      
                    $message = $e->getMessage();
          
                    $code = $e->getCode();       
          
                    $string = $e->__toString();       
                    return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                    exit;
            }
       }


       public function cancelOrder(Request $request)
       {
           try
           {
               $validator = Validator::make($request->all(), [
                    'order_id' => 'required|integer',
                    'user_id' => 'required|integer',
                    'status' => 'required|string'
                ]);

               if($validator->fails()){
                    return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
                }

               $get_order = Order::findorfail($request->order_id);

               $get_user = User::findorfail($request->user_id);

                $order = new CancelOrder();
                $order->order_id = $get_order->id;
                $order->user_id = $get_user->id;
                $order->status = $request->status;
                $order->save();


                return response()->json(['status'=>true, 'message'=>'Successfully order has been cancel']);

           }catch(Exception $e){
                      
                    $message = $e->getMessage();
          
                    $code = $e->getCode();       
          
                    $string = $e->__toString();       
                    return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                    exit;
            }
       }

       public function afterCancelorder(Request $request)
       { 
           try
           {
               $validator = Validator::make($request->all(), [
                    'order_id' => 'required|integer',
                    'user_id' => 'required|integer',
                ]);

               if($validator->fails()){
                    return ['status'=>false, 'message'=>'The given data was invalid', 'data'=>$validator->errors()];  
                }

                $order = Order::findorfail($request->order_id);
                
                $user = User::findorfail($request->user_id);

                $cancel_order = CancelOrder::where('order_id',$order->id)->where('user_id',$request->user_id)->first();
                
                $cancel_order_ids = CancelOrder::where('order_id',$order->id)->pluck('user_id')->toArray();

                    if($order->status == 'cancel' || $order->status == 'pending')
                    {
                        $lat = $order->pickup_lat;
                        $lon = $order->pickup_lon;

                        $firebaseToken = User::select("users.id","users.lat", "users.lon", "users.device_token"
                                        ,DB::raw("6371 * acos(cos(radians(" . $lat . ")) 
                                        * cos(radians(users.lat)) 
                                        * cos(radians(users.lon) - radians(" . $lon . ")) 
                                        + sin(radians(" .$lat. ")) 
                                        * sin(radians(users.lat))) AS distance"))
                                        ->where('users.role', 'delivery_men')
                                        ->where('users.device_token', '!=', NULL)
                                        ->where('users.online', 'yes')
                                        ->whereNotIn('users.id', $cancel_order_ids)
                                        ->orderBy('distance', 'ASC')
                                        ->limit(1)
                                        ->pluck('device_token')
                                        ->all();

                                        
                        if(count($firebaseToken) == 0)
                        {
                            return response()->json(['status'=>false, 'order_id'=>intval($request->order_id), 'message'=>'No driver found']);
                        }
                        
                        // FCM endpoint
                        $endpoint = 'https://fcm.googleapis.com/fcm/send';
                        
                        // Server key obtained from Firebase Console
                        $serverKey = getFirebase()->app_key;
                        
                        // Array of device tokens
                        $deviceTokens = $firebaseToken;

                        $payload = [

                          'data' => [
                             'title' => 'Courier Delivery',
                            'body' => 'New Order Request',
                            "click_action"=> "MAIN_ACTIVITY",
                            'notification_id' => intval($request->order_id)
                          ],
                          'registration_ids' => $firebaseToken
                        ];
                        
                        $headers = [
                          'Authorization: key=' . $serverKey,
                          'Content-Type: application/json'
                        ];
                        
                        $ch = curl_init($endpoint);
                        
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($ch, CURLOPT_POST, true);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
                        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                        
                        $response = curl_exec($ch);

                        curl_close($ch);
                        
                     
                        
                        return response()->json(['status'=>true, 'order_id'=>intval($request->order_id), 'message'=>'Successfully notification send to all deliverymen']);
                    }
                    else{
                        return response()->json(['status'=>false, 'order_id'=>intval($request->order_id), 'message'=>'Sorry the order is proccessing by others deliverymen']);
                    }
                
                
           }catch(Exception $e){
                      
                    $message = $e->getMessage();
          
                    $code = $e->getCode();       
          
                    $string = $e->__toString();       
                    return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                    exit;
            }
       }

     
     public function getBrands($id)
     {
        try
        {
            $brands = Brand::where('type_id',$id)->get();
            if(count($brands) > 0)
            {
                return response()->json(['status'=>true, 'message'=>'Data found', 'total'=>count($brands), 'data'=>$brands]);
            }
            return response()->json(['status'=>false, 'message'=>'No data found', 'total'=>count($brands), 'data'=>$brands]);

        }catch(Exception $e){
                      
                    $message = $e->getMessage();
          
                    $code = $e->getCode();       
          
                    $string = $e->__toString();       
                    return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                    exit;
            }
     }



     public function currentWeek($id)
    {
        try
        {
            $year = date('Y');

            $startOfYear = Carbon::createFromDate($year, 1, 1); 
            $endOfYear = Carbon::createFromDate($year, 12, 31); 
            
            $currentWeekStartDate = Carbon::now()->startOfWeek();
            $currentWeekEndDate = Carbon::now()->endOfWeek();
            
            $arrs = [];
            
            for ($date = $startOfYear->copy()->startOfWeek(); $date->lte($endOfYear); $date->addWeek()) {
                $weekNumber = $date->weekOfYear;
                
                if ($date->equalTo($currentWeekStartDate)) {
                    $currentWeekTotalPrice = DB::table('orders')
                        ->where('orders.date', '>=', $date->format('Y-m-d'))
                        ->where('orders.date', '<=', $date->copy()->endOfWeek()->format('Y-m-d'))
                        ->where('user_id', $id)
                        ->sum('total_price');
            
                    $percentage = 20;
                    $amount = ($percentage / 100) * $currentWeekTotalPrice;
            
                    $arrs[] = [
                        'from_date' => $date->format('Y-m-d'),
                        'to_data' => $date->copy()->endOfWeek()->format('Y-m-d'),
                        'start_date' => $date->format('M d'),
                        'end_date' => $date->copy()->endOfWeek()->format('M d'),
                        'total_price' => intval($currentWeekTotalPrice) - $amount
                    ];
            
                    break; // Stop looping after the current week is found
                }
            }
            
            $data = [];
            foreach ($arrs as $row) {
                $start_date = Carbon::parse($row['from_date']);
                $end_date = Carbon::parse($row['to_data']);
                $days = [];
                for ($date = $start_date; $date->lte($end_date); $date->addDay()) {
                    $days[] = ['day' => intval($date->format('d'))];
                }
            
                $data[] = [
                    'from_date' => $row['from_date'],
                    'to_date' => $row['to_data'],
                    'start_date' => $row['start_date'],
                    'end_date' => $row['end_date'],
                    'total_price' => $row['total_price'],
                    'days' => $days
                ];
            }
            
            return response()->json(['status' => true, 'data' => $data]);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

}
 