<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Order;
use DataTables;
use Auth;
use App\Models\Userbank;
use App\Models\Withdrawrequest;
class ReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth_check');
    }

    public function dailyReport(Request $request)
    {
    	try
    	{   
    		if($request->ajax()) {
                $data = Order::join('users', 'orders.user_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                         ->orderBy('orders.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()
                       
                        ->addColumn('action', function($row){

                            
                          

                              $btn = ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('date_range') != "")
                            {
                                $explode = explode("to", $request->get('date_range'));

                                $from_date = str_replace(" ","",$explode[0]);
                                $end_date =  str_replace(" ","",$explode[1]);

                                $convert_fromDate = date("Y-m-d", strtotime($from_date));
                                $convert_toDate = date("Y-m-d", strtotime($end_date));

                                $instance->where('orders.date', '>=', $convert_fromDate)->where('orders.date', '<=', $convert_toDate);
                            }
                            
                        })
                        ->rawColumns(['action'])
                        ->make(true); 
            }
    		return view('report.daily_report');
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function monthlyYearlyReport(Request $request)
    {
    	try
    	{
    		if($request->ajax()) {
                $data = Order::join('users', 'orders.user_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                         ->orderBy('orders.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()
                       
                        ->addColumn('action', function($row){

                            
                          

                              $btn = ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('select_month') != "")
                            {
                                $instance->where('orders.month', $request->get('select_month'));
                            }

                            if($request->get('select_year') != "")
                            {
                                $instance->where('orders.year', $request->get('select_year'));
                            }
                            
                        })
                        ->rawColumns(['action'])
                        ->make(true); 
            }
    		return view('report.monthly_yearly_report');
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function customReport(Request $request)
    {
    	try
    	{
    		if($request->ajax()) {
                $data = Order::join('users', 'orders.user_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                         ->orderBy('orders.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()
                       
                        ->addColumn('action', function($row){

                            
                          

                              $btn = ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('select_section') != "")
                            {
                                if($request->get('select_section') == 'today')
                                {
                                	$instance->where('orders.date', today()); 
                                }

                                if($request->get('select_section') == 'yesterday')
                                {
                                	$instance->where('orders.date', yesterday()); 
                                }

                                if($request->get('select_section') == 'this_month')
                                {
                                	$instance->where('orders.month', currentMonth()); 
                                }

                                if($request->get('select_section') == 'last_seven_days')
                                {
                                	$instance->where('orders.date', '>=', lastSevenDays()); 
                                }

                                if($request->get('select_section') == 'last_fifteen_days')
                                {
                                	$instance->where('orders.date', '>=', lastfifteenDays()); 
                                }

                                if($request->get('select_section') == 'last_thirty_days')
                                {
                                	$instance->where('orders.date', '>=', lastthirtyDays()); 
                                }

                            }
                            
                        })
                        ->rawColumns(['action'])
                        ->make(true); 
            }
    		return view('report.custom_report');
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
    
    public function myDailyReport(Request $request)
    {
        try
        {    
            
            if($request->ajax()) { 
                $data = Order::join('users', 'orders.sender_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                          ->where('orders.vendor_id', Auth::user()->id)

                         ->orderBy('orders.id', 'DESC');
          
                return Datatables::of($data)
                        ->addIndexColumn()

                        ->addColumn('status', function($row){


                       $selectedValue = ($row->status == 'pending') ? 'selected' : '';
                       $selectedValueTwo = ($row->status == 'accept') ? 'selected' : '';

                        $selectedValueThree = ($row->status == 'collect_item') ? 'selected' : '';

                        $selectedValueFour= ($row->status == 'receive_payment') ? 'selected' : '';

                        $selectedValueFive = ($row->status == 'shipping') ? 'selected' : '';

                        $selectedValueSix = ($row->status == 'delivered') ? 'selected' : '';

                            return "<select class='form-control update-change-stataus' data-id=".$row->id."><option value='' selected='' disabled=''>Select status</option><option value='pending' ".$selectedValue.">Pending</option><option value='accept' ".$selectedValueTwo.">Accept</option><option value='collect_item' ".$selectedValueThree.">Collect Item</option><option value='receive_payment' ".$selectedValueFour.">Receive payment</option><option value='shipping' ".$selectedValueFive.">Shipping</option><option value='delivered' ".$selectedValueSix.">Delivered</option></select>";

                          
                             
                        })

                       
                        ->addColumn('action', function($row){

                            
                          

                              $btn = "";
                              $btn .= ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
                              
                              
                               $btn .= '&nbsp;';


                              $btn .= ' <a href="'.url('/set-vendor/'.$row->id).'" class="btn btn-danger btn-sm set-vendor action-button"><i class="fa fa-users"></i></a>';
                              
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('date_range') != "")
                            {
                                $explode = explode("to", $request->get('date_range'));

                                $from_date = str_replace(" ","",$explode[0]);
                                $end_date =  str_replace(" ","",$explode[1]);

                                $convert_fromDate = date("Y-m-d", strtotime($from_date));
                                $convert_toDate = date("Y-m-d", strtotime($end_date));

                                $instance->where('orders.date', '>=', $convert_fromDate)->where('orders.date', '<=', $convert_toDate);
                            }
                            
                        })
                        ->rawColumns(['action', 'status'])
                        ->make(true); 
            }
            return view('report.my_daily_report');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function mymonthlyYearlyReport(Request $request)
    {
        try
        {
            if($request->ajax()) {
                $data = Order::join('users', 'orders.sender_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                         ->where('orders.vendor_id', Auth::user()->id)
                         ->orderBy('orders.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()

                        ->addColumn('status', function($row){


                       $selectedValue = ($row->status == 'pending') ? 'selected' : '';
                       $selectedValueTwo = ($row->status == 'accept') ? 'selected' : '';

                        $selectedValueThree = ($row->status == 'collect_item') ? 'selected' : '';

                        $selectedValueFour= ($row->status == 'receive_payment') ? 'selected' : '';

                        $selectedValueFive = ($row->status == 'shipping') ? 'selected' : '';

                        $selectedValueSix = ($row->status == 'delivered') ? 'selected' : '';

                            return "<select class='form-control update-change-stataus' data-id=".$row->id."><option value='' selected='' disabled=''>Select status</option><option value='pending' ".$selectedValue.">Pending</option><option value='accept' ".$selectedValueTwo.">Accept</option><option value='collect_item' ".$selectedValueThree.">Collect Item</option><option value='receive_payment' ".$selectedValueFour.">Receive payment</option><option value='shipping' ".$selectedValueFive.">Shipping</option><option value='delivered' ".$selectedValueSix.">Delivered</option></select>";

                          
                             
                        })

                       
                        ->addColumn('action', function($row){

                            
                          

                              $btn = "";
                              $btn .= ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
                              
                              
                               $btn .= '&nbsp;';


                              $btn .= ' <a href="'.url('/set-vendor/'.$row->id).'" class="btn btn-danger btn-sm set-vendor action-button"><i class="fa fa-users"></i></a>';
                              
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('select_month') != "")
                            {
                                $instance->where('orders.month', $request->get('select_month'));
                            }

                            if($request->get('select_year') != "")
                            {
                                $instance->where('orders.year', $request->get('select_year'));
                            }
                            
                        })
                        ->rawColumns(['action', 'status'])
                        ->make(true); 
            }
            return view('report.my_monthly_yearly_report');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function mycustomReport(Request $request)
    {
        try
        {
            if($request->ajax()) {
                $data = Order::join('users', 'orders.sender_id', 'users.id')
                         ->join('paymentmethods', 'orders.paymentmethod_id', 'paymentmethods.id')
                         ->select('orders.id', 'orders.date', 'orders.status', 'users.name as customer_name', 'users.phone as customer_phone', 'paymentmethods.name as payment_method')
                         ->where('orders.vendor_id',Auth::user()->id)
                         ->orderBy('orders.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()
                       ->addColumn('status', function($row){


                       $selectedValue = ($row->status == 'pending') ? 'selected' : '';
                       $selectedValueTwo = ($row->status == 'accept') ? 'selected' : '';

                        $selectedValueThree = ($row->status == 'collect_item') ? 'selected' : '';

                        $selectedValueFour= ($row->status == 'receive_payment') ? 'selected' : '';

                        $selectedValueFive = ($row->status == 'shipping') ? 'selected' : '';

                        $selectedValueSix = ($row->status == 'delivered') ? 'selected' : '';

                            return "<select class='form-control update-change-stataus' data-id=".$row->id."><option value='' selected='' disabled=''>Select status</option><option value='pending' ".$selectedValue.">Pending</option><option value='accept' ".$selectedValueTwo.">Accept</option><option value='collect_item' ".$selectedValueThree.">Collect Item</option><option value='receive_payment' ".$selectedValueFour.">Receive payment</option><option value='shipping' ".$selectedValueFive.">Shipping</option><option value='delivered' ".$selectedValueSix.">Delivered</option></select>";

                          
                             
                        })
                        ->addColumn('action', function($row){

                            
                          

                              $btn = "";
                              $btn .= ' <a href="#" class="btn btn-info btn-sm show-report action-button" data-id="'.$row->id.'"><i class="fa fa-eye"></i></a>'; 
                              
                              
                               $btn .= '&nbsp;';


                              $btn .= ' <a href="'.url('/set-vendor/'.$row->id).'" class="btn btn-danger btn-sm set-vendor action-button"><i class="fa fa-users"></i></a>';
                              
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {
                            if ($request->get('search') != "") {
                                 $instance->where(function($w) use($request){
                                    $search = $request->get('search');
                                    $w->orWhere('users.name', 'LIKE', "%$search%")
                                    ->orWhere('users.email', 'LIKE', "%$search%")
                                    ->orWhere('users.phone', 'LIKE', "%$search%");
                                });
                            }

                            if ($request->get('status') == 'pending' || $request->get('status') == 'accept' || $request->get('status') == 'pickup' || $request->get('status') == 'shipping') {
                                $instance->where('orders.status', $request->get('status'));
                            }

                            if($request->get('select_section') != "")
                            {
                                if($request->get('select_section') == 'today')
                                {
                                    $instance->where('orders.date', today()); 
                                }

                                if($request->get('select_section') == 'yesterday')
                                {
                                    $instance->where('orders.date', yesterday()); 
                                }

                                if($request->get('select_section') == 'this_month')
                                {
                                    $instance->where('orders.month', currentMonth()); 
                                }

                                if($request->get('select_section') == 'last_seven_days')
                                {
                                    $instance->where('orders.date', '>=', lastSevenDays()); 
                                }

                                if($request->get('select_section') == 'last_fifteen_days')
                                {
                                    $instance->where('orders.date', '>=', lastfifteenDays()); 
                                }

                                if($request->get('select_section') == 'last_thirty_days')
                                {
                                    $instance->where('orders.date', '>=', lastthirtyDays()); 
                                }

                            }
                            
                        })
                        ->rawColumns(['action', 'status'])
                        ->make(true); 
            }
            return view('report.my_custom_report'); 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function withdrawReport(Request $request)
    {
        try
        {
            if($request->ajax()) {
                $data = Withdrawrequest::join('users', 'withdrawrequests.user_id', 'users.id')
                                ->join('userbanks', 'withdrawrequests.bank_id', 'userbanks.id')
                                 ->select('withdrawrequests.*', 'userbanks.bank_name', 'users.name as deliverymen', 'userbanks.account_number')
                                 ->orderBy('withdrawrequests.id', 'DESC');

                return Datatables::of($data)
                        ->addIndexColumn()
                       

                        ->addColumn('status', function($row){

                             return $row->status;
                        })
                       
                        ->addColumn('action', function($row){

                          if($row->status == 'Approved')
                            {
                                $btn = ' <a href="#" class="btn btn-danger btn-sm decline-withdraw action-button" data-id="'.$row->id.'"><i class="fa fa-ban"></i></a>';
                            }
                            else
                            {
                                $btn = '<button type="button" class="btn btn-info btn-sm active-withdraw action-button" data-id="'.$row->id.'"><i class="fa fa-check"></i></button>';
                            }  
                          
        
                                return $btn;
                        })->filter(function ($instance) use ($request) {

                            if ($request->get('status') == 'Pending' || $request->get('Approved')) {
                                $instance->where('withdrawrequests.status', $request->get('status'));
                            }

                            if($request->get('select_section') != "")
                            {
                                if($request->get('select_section') == 'today')
                                {
                                    $instance->where('withdrawrequests.date', today()); 
                                }

                                if($request->get('select_section') == 'yesterday')
                                {
                                    $instance->where('withdrawrequests.date', yesterday()); 
                                }

                                if($request->get('select_section') == 'this_month')
                                {
                                    $instance->whereMonth('withdrawrequests.date', currentMonth()); 
                                }

                                if($request->get('select_section') == 'last_seven_days')
                                {
                                    $instance->where('withdrawrequests.date', '>=', lastSevenDays()); 
                                }

                                if($request->get('select_section') == 'last_fifteen_days')
                                {
                                    $instance->where('withdrawrequests.date', '>=', lastfifteenDays()); 
                                }

                                if($request->get('select_section') == 'last_thirty_days')
                                {
                                    $instance->where('withdrawrequests.date', '>=', lastthirtyDays()); 
                                }

                                if($request->get('select_section') == 'this_year')
                                {
                                    $instance->whereYear('withdrawrequests.date', currentYear()); 
                                }

                            }
                            
                        })
                        ->rawColumns(['action', 'status'])
                        ->make(true); 
            }
            return view('report.withdraw_report');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }
    
}
