<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Models\Setprice;
use App\Models\User;
use Auth;
use App\Http\Requests\PasswordChangeRequest;
use App\Http\Requests\UpdateAccountRequest;
use App\Http\Requests\ProjectRequest;
use Hash;
use DataTables;
use App\Models\Paymentmethod;
use App\Models\Order;
use Session;


class SettingConroller extends Controller 
{  

    public function __construct()
    {
        $this->middleware('auth_check');
    }
    
    public function citySettings()
    {
    	try
    	{
    		return view('settings.city');
    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function setCity(Request $request)
    {
    	try
    	{   
    	  if($request->district_id)
    	  {  
    	  	 $count = DB::table('cities')->where('division_id',$request->division_id)->where('district_id',$request->district_id)->count();

    	  	 if($count > 0)
    	  	 {
    	  	 	DB::table('cities')->where('division_id',$request->division_id)->where('district_id',$request->district_id)->delete();
    	  	 }

    	  	  
    	  }
    	  else
    	  {
    	  	 $count = DB::table('cities')->where('division_id',$request->division_id)->count();

    	  	 if($count > 0)
    	  	 {
    	  	 	DB::table('cities')->where('division_id',$request->division_id)->delete();
    	  	 }
    	  }
    	  if($request->thanas)
    	  {   

    	  	   for($count=0; $count < count($request->thanas); $count++)
		        {
		           $data_var = array(
		              'division_id' => $request->division_id,
		              'district_id' => $request->district_id,
		              'thana_id' => $request->thanas[$count],
		           );
		           $insert_data[] = $data_var;
		            
		        }
	       
	          DB::table('cities')->insert($insert_data);

	          $notification=array(
                             'messege'=>"Successfully city has been added",
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification); 
    	  }
    		

    	}catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function priceSetting()
    {
        try
        {
            return view('settings.price_setting');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function setPrice(Request $request)
    {
        try
        {
            Setprice::where('id',priceSetting()->id)->update(['per_km'=>$request->per_km, 'per_weight'=>$request->per_weight]);
            $notification=array(
                             'messege'=>"Successfully info has been updared",
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification); 

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function accountSettings()
    {
        try
        {
            return view('account_settings');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function settingsAccount(UpdateAccountRequest $request)
    {
        try
        {   
            

            $user = User::find(Auth::user()->id);

            if($request->file('image'))
            {    
                $image = $request->file('image');
                $name = time().$image->getClientOriginalName();
                $image->move(public_path().'/uploads/profile/', $name); 
                $path = 'uploads/profile/'.$name;
            }
            else
            {
                $path = $user->image;
            }

            $user->name = $request->name;
            $user->email = $request->email;
            $user->image = $path;
            $user->update();
            $notification=array(
                             'messege'=>"Successfully updated",
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function changePassword()
    {
        try
        {
           return view('change_password'); 
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function passwordChange(PasswordChangeRequest $request)
    {
        try
        {   
            $user = User::find(Auth::user()->id);

            if (!Hash::check($request->current_password, $user->password)) {
            
              

               $notification=array(
                             'messege'=>"The current password is incorrect.",
                             'alert-type'=>'error'
                            );

            return Redirect()->back()->with($notification);

            }

            $user->password = Hash::make($request->new_password);
            $user->update();

             $notification=array(
                             'messege'=>"Successfully updated",
                             'alert-type'=>'success'
                            );

            return Redirect()->back()->with($notification);


        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function paymentSetting(Request $request)
    {
        try
        {   
            if($request->ajax()) {
                $data = Paymentmethod::where('id','!=', 4)->select('*');
                return Datatables::of($data)
                        ->addIndexColumn()
                        ->addColumn('status', function($row){
                            if($row->status == 'Active') 
                            {
                                return "<span class='badge badge-primary p-2'>" . $row->status . "</span>";
                            }
                            else
                            {
                                return "<span class='badge badge-danger p-2'>" . $row->status . "</span>";
                            }
                        })
                       
                        ->addColumn('action', function($row){

                            if($row->status == 'Active')
                            {
                                $btn = ' <a href="#" class="btn btn-danger btn-sm decline-option action-button" data-id="'.$row->id.'"><i class="fa fa-ban"></i></a>';
                            }
                            else
                            {
                                $btn = '<button type="button" class="btn btn-info btn-sm active-option action-button" data-id="'.$row->id.'"><i class="fa fa-check"></i></button>';
                            }
                             
                             

                            $btn .= '&nbsp;';
                            if($row->id == 1)
                            {
                                $btn .= ' <a href="#" class="btn btn-primary btn-sm action-button" data-id="'.$row->id.'" disabled><i class="fa fa-edit"></i></a>';
                            }
                            else
                            {
                                $btn .= ' <a href="#" class="btn btn-primary btn-sm action-button edit-option" data-id="'.$row->id.'"><i class="fa fa-edit"></i></a>';
                            }
                            

        
                                return $btn;
                        })
                        ->rawColumns(['action', 'status'])
                        ->make(true); 
            }
            
            return view('settings.payment_settings');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function paymentDecline($id)
    {
        try
        {
            Paymentmethod::where('id',$id)->update(['status'=>'Inactive']);
            return response()->json('Successfully Inactived');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function paymentActive($id)
    {
        try
        {
            Paymentmethod::where('id',$id)->update(['status'=>'Active']);
            return response()->json('Successfully Actived');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function paymentShow($id)
    {
        try
        {
            $data = Paymentmethod::findorfail($id);
            return response()->json($data);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function paymentInfoUpdate(Request $request)
    {
        try
        {
            $payment = Paymentmethod::findorfail($request->payment_id);
            $payment->name = $request->name;
            $payment->api_key = $request->api_key;
            $payment->api_secret = $request->api_secret;
            $payment->status = $payment->status;
            $payment->update();
            return response()->json('Successfully payment info updated');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function mailSettings()
    {
        return view('mail_settings');
    }


    public function settingsMail(Request $request)
    {
        try
        {
            
            customMail($request);
            

            $host = env('MAIL_HOST');
            
            $port = env('MAIL_PORT');

            $email = env('MAIL_USERNAME');

            $password = env('MAIL_PASSWORD');

            $encryption = env('MAIL_ENCRYPTION');

            $from_address = env('MAIL_FROM_ADDRESS');


            $path = base_path('.env');
            $test = file_get_contents($path);

            if (file_exists($path)) {
                $replacements = [

                    "MAIL_HOST=$host" => "MAIL_HOST=$request->mail_host",
                    "MAIL_PORT=$port" => "MAIL_PORT=$request->mail_port",
                    "MAIL_USERNAME=$email" => "MAIL_USERNAME=$request->email",
                    "MAIL_PASSWORD=$password" => "MAIL_PASSWORD=$request->password",
                    "MAIL_ENCRYPTION=$encryption" => "MAIL_ENCRYPTION=$request->mail_encryption",

                     "MAIL_FROM_ADDRESS=$from_address" => "MAIL_FROM_ADDRESS=$request->email",

                    // Add more key-value pairs for other replacements if needed
                ];

                foreach ($replacements as $search => $replace) {
                    $test = str_replace($search, $replace, $test);
                }

                file_put_contents($path, $test);
            }
              

             $notification=array(
                             'messege'=>"Successfully mail information has been added",
                             'alert-type'=>'success'
                            );

            return redirect()->back()->with($notification);
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function firebaseSetting()
    {
        try
        {
            return view('firebase_setting');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function settingsFirebase(Request $request)
    {
        try
        {
            $firebase = getFirebase();
            $firebase->app_key = $request->app_key;
            $firebase->update();

            $notification=array(
                             'messege'=>"Successfully firebase information has been added",
                             'alert-type'=>'success'
                            );

            return redirect()->back()->with($notification);

        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }



    public function projectSettings()
    {
        try
        {
            return view('project_settings');
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

    public function settingsProject(ProjectRequest $request)
    {
        try
        {   
            
            $project = project();
            if($request->file('project_logo'))
            {    
                $project_logo = $request->file('project_logo');
                $name = time().$project_logo->getClientOriginalName();
                $project_logo->move(public_path().'/uploads/project/', $name); 
                $path = 'public/uploads/project/'.$name;
            }
            else
            {
                $path = $project->project_logo;
            }

            $project->project_name = $request->project_name;
            $project->project_logo = $path;
            $project->update();

            $notification=array(
                             'messege'=>"Successfully project information has been updated",
                             'alert-type'=>'success'
                            );

            return redirect('/project-settings')->with($notification);   
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }


    public function setVendor(Request $request,$id)
    {    
          
 
          Session::put('previous_url', $request->headers->get('referer'));
           $order = Order::findorfail($id);
           
           
           $base_url = url('/');
            $lat = $order->pickup_lat;
            $lon = $order->pickup_lon;
            $distance = 20;
            $users = User::select("users.id", "users.name", "users.phone", "users.email", "users.lat", "users.lon", \DB::raw("CONCAT('$base_url/', users.image) AS image")
                            ,DB::raw("6371 * acos(cos(radians(" . $lat . ")) 
                            * cos(radians(users.lat)) 
                            * cos(radians(users.lon) - radians(" . $lon . ")) 
                            + sin(radians(" .$lat. ")) 
                            * sin(radians(users.lat))) AS distance"))
                            ->where('users.role', 'vendor')
                            ->where('users.id', '!=', $order->vendor_id)
                            ->having('distance', '<=', $distance)
                            ->orderBy('distance', 'ASC')
                            ->get();                 
        return view('set_vendor', compact('id','users', 'order'));
    }
    
    public function vendorSet(Request $request)
    {
        try
        { 
            
            $order = Order::findorfail($request->order_id);
            
            $order->user_id = $request->user_id;
            
             $order->update();
            $notification=array(
                             'messege'=>"Successfully district has been added",
                             'alert-type'=>'success'
                            );

            return redirect()->to(Session::get('previous_url'));
            
           
            
            
            
            
        }catch(Exception $e){
                  
                $message = $e->getMessage();
      
                $code = $e->getCode();       
      
                $string = $e->__toString();       
                return response()->json(['message'=>$message, 'execption_code'=>$code, 'execption_string'=>$string]);
                exit;
        }
    }

   
}
