<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Session;
class Slider extends Model
{
    use HasFactory;

    public function sliders()
    {
    	$sliders = Self::latest()->get();
    	return $sliders;
    }

    public function storeSlider(Request $request)
    {
    	if($request->file('image'))
    	{    
    		$image = $request->file('image');
    		$name = time().$image->getClientOriginalName();
            $image->move(public_path().'/uploads/sliders/', $name); 
            $path = 'uploads/sliders/'.$name;
    	}

    	$slider = new Slider();
    	$slider->image = $path;
    	$slider->save();
    	$message = "Successfully slider has been added";
    	Session::put('message', $message);
    	return $message;
    }

    public function updateSlider(Request $request, $slider)
    {
    	if($request->file('image'))
    	{    
    		$image = $request->file('image');
    		$name = time().$image->getClientOriginalName();
            $image->move(public_path().'/uploads/sliders/', $name); 
            unlink(public_path($slider->image));
            $path = 'uploads/sliders/'.$name;
    	}

    	$slider->image = $path;
    	$slider->update();
    	$message = "Successfully slider has been updated";
    	Session::put('message', $message);
    	return $message;
    }

    public function deleteSlider($slider)
    {
    	unlink(public_path($slider->image));
    	$slider->delete();
    	$message = 'Successfully the slider has been deleted';
        return $message;
    }


}
