<?php
use App\Models\CityCorporation;
use App\Models\Division;
use App\Models\District;
use App\Models\User;
use App\Models\Setprice;
use App\Models\Mail;
use App\Models\Firebase;
use App\Models\Projectsetting;
use App\Models\Paymentmethod;
use Illuminate\Http\Request;
use App\Models\Brand;

 function storeProject()
 {
 	 $projectsettings = array(
		  array('id' => '1','project_name' => 'GoCourier','project_logo' => 'logo2.jpg','created_at' => NULL,'updated_at' => NULL)
		);

 	 DB::table('projectsettings')->insert($projectsettings);
 }
 
 function project()
 {
 	$project = Projectsetting::find(1);
 	return $project;
 }

 function cities($id)
 {  
 	if(!$id)
 	{
 		$cities = CityCorporation::where('country',Auth::user()->country)->latest()->get();
 	}
 	$user = User::findorfail($id);
 	$cities = CityCorporation::where('division_id',$user->division_id)->where('country',Auth::user()->country)->get(); 
 	 return $cities;
 }

 function divisions()
 {
 	$divisions = Division::latest()->get(); 
 	return $divisions;
 }

 function districts($id)
 {  
 	if(!$id)
 	{    
 		$districts = District::orderBy('id','DESC')->get();
 	}
    

 	$districts = District::where('division_id',$id)->get();
 	 
 	 return $districts;
 }

 function thanas($id)
 {
 	if(!$id)
 	{    
 		$thanas = Thana::where('country',Auth::user()->country)->orderBy('id','DESC')->get();
 	}
    

 	$thanas = Thana::where('district_id',$id)->get();
 	 
 	 return $thanas;
 }


function getPrice()
{
	 $data = Setprice::find(1);
	 return $data;
 }

 function yesterday()
 {
 	 $yesterday = date('Y-m-d', strtotime('-1 day'));
 	 return $yesterday;
 }

 function currentMonth()
 {
 	 $month = date('F');
 	 return $month;
 }

 function lastSevenDays()
 {
 	 $sevenDaysAgo = date('Y-m-d', strtotime('-7 days'));
 	 return $sevenDaysAgo;
 }

 function lastfifteenDays()
 {
 	$data = date('Y-m-d', strtotime('-15 days'));
 	 return $data;
 }

 function lastthirtyDays()
 {
 	$data = date('Y-m-d', strtotime('-30 days'));
 	 return $data;
 }


 function myMail()
 {
 	 $mails = array(
	  array('id' => '1','email' => NULL,'mail_host' => NULL,'mail_port' => NULL,'mail_encryption' => NULL,'password' => NULL,'created_at' => NULL,'updated_at' => NULL)
	);

 	DB::table('mails')->insert($mails);
 }
 

 function mailData()
 {
 	$mail = Mail::find(1);
 	return $mail;
 }

 function firebase()
 {
 	  $firebases = array(
		  array('id' => '1','app_key' => NULL,'created_at' => NULL,'updated_at' => NULL)
		);

 	  DB::table('firebases')->insert($firebases);
 }

 function getFirebase()
 {
 	$firebase = Firebase::find(1);
 	return $firebase; 
 }

 function durationMonth($id)
 {
 	 $user = User::find($id);
 	 $date = new \DateTime($user->created_at);

      $dateOnly = $date->format('Y-m-d');

        $origin = new \DateTime($dateOnly);
		$target = new \DateTime(date('Y-m-d'));
		$interval = $origin->diff($target);
		return $interval->format('%m'); 
 }






 function customMail(Request $request)
{
	$mail = Mail::findorfail(1);
    $mail->email = $request->email;
    $mail->mail_host = $request->mail_host;
    $mail->mail_port = $request->mail_port;
    $mail->mail_encryption = $request->mail_encryption;
    $mail->password = $request->password;
    $mail->update();

    return $mail;
}

function setPrices()
{
	$setprices = array(
	  array('id' => '1','per_km' => NULL,'per_weight' => NULL,'created_at' => NULL,'updated_at' => NULL)
	);

	DB::table('setprices')->insert($setprices); 
}

function priceSetting()
{
	$data = Setprice::find(1);
	return $data;
}

function timezones()
{
	$timezones = \DateTimeZone::listIdentifiers();
     return $timezones;
}

function getDistricts()
{
	$data = District::orderBy('id','DESC')->get();
	return $data;
}


function pathValue()
{
   $request = Request::capture();
   $currentUrl = $request->url();

   $expectedValue = 'report'; // Replace with the value you're expecting
   $includesExpectedValue = str_contains($currentUrl, $expectedValue);
   
   if ($includesExpectedValue) {
       return 1;
	} else {
	    return 0;
     }
   return $currentUrl;
}


function currentYear()
{
	$year = date('Y');
	return $year;
}

function storePaymentmethods()
{   
	$count = DB::table('paymentmethods')->count();
	if($count == 0)
	{
		$paymentmethods = array(
		  array('id' => '1','name' => 'Cash On Delivery','image' => 'public/uploads/gateway/cod.png','api_key' => NULL,'api_secret' => NULL,'status' => 'Active','created_at' => NULL,'updated_at' => '2023-06-03 05:09:49'),
		  array('id' => '2','name' => 'Stripe','image' => 'public/uploads/gateway/stripe.png','api_key' => 'pk_test_reFxwbsm9cdCKASdTfxAR','api_secret' => 'sk_test_4eC39HqLyjWDarjtT1zdp7dc','status' => 'Active','created_at' => NULL,'updated_at' => '2023-06-01 05:52:27'),
		  array('id' => '3','name' => 'Razorpay','image' => 'public/uploads/gateway/razorpay.png','api_key' => 'rzp_test_kFK5ZWoO9wK0c4','api_secret' => 'qnURzWRGQsb3rMT002I3bnij','status' => 'Active','created_at' => NULL,'updated_at' => '2023-06-01 05:43:56'),
		  array('id' => '4','name' => 'Digital Payment','image' => NULL,'api_key' => NULL,'api_secret' => NULL,'status' => 'Active','created_at' => NULL,'updated_at' => NULL)
		);

	   DB::table('paymentmethods')->insert($paymentmethods);
	}


	
	
}