<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('sender_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->enum('place_type', ['inside_city', 'outside_city'])->nullable();
            $table->string('receiver_name')->nullable();
            $table->string('receiver_phone')->nullable();
            $table->integer('division_id')->nullable();
            $table->integer('district_id')->nullable();
            $table->integer('thana_id')->nullable();
            $table->text('full_address')->nullable();
            $table->integer('weight')->default('0')->nullable();
            $table->enum('item_type', ['document', 'parcel'])->nullable();
            $table->string('pickup_lat')->nullable();
            $table->string('pickup_lon')->nullable();
            $table->text('guide')->nullable();
            $table->text('parcel_details')->nullable();
            $table->enum('courier_method', ['home_pickup', 'agent'])->default('home_pickup')->nullable();
            $table->enum('payby', ['sender', 'receiver'])->nullable();
            $table->integer('paymentmethod_id')->nullable();
            $table->integer('total_price')->nullable();
            $table->integer('earning_price')->nullable();
            $table->string('is_pickup')->nullable();
            $table->string('is_collectpay')->nullable();
            $table->enum('status', ['pending', 'accept', 'pickup', 'shipping', 'delivered', 'cancel', 'collect_item', 'receive_payment', 'submit'])->default('Pending')->nullable();
            $table->date('date')->nullable();
            $table->string('time')->nullable();
            $table->string('month')->nullable();
            $table->string('year')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
