@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Add Brand</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Add Brand</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Add Brand</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('brands.store')}}" method="POST" enctype="multipart/form-data">
              	@csrf
                <div class="card-body">

                <div class="form-group">
                  <label for="brand">Brand Name <span class="required">*</span></label>
                  <input type="text" name="brand" class="form-control" id="brand" placeholder="Brand Name" value="{{old('brand')}}" required="">
                  @error('brand')
		                 <span class="alert alert-danger">{{ $message }}</span>
                  @enderror 
                     
                </div>

                <div class="form-group">
                  <label for="type_id">Select Vehicle Type <span class="required">*</span></label>
                  <select class="form-control select2bs4" name="type_id" id="type_id" required="">
                      <option value="" selected="" disabled="">Select Vehicle Type</option>
                      @foreach($types as $type)
                      <option value="{{$type->id}}">{{$type->type}}</option>
                      @endforeach
                  </select>
                  @error('type_id')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>

                </div>

                  
                </div>
                <!-- /.card-body -->

                
              </form>
            </div>
    </section>
 </div>
@endsection