@extends('admin_master')
@section('content')
 
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">All District</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">All District</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card">
              <div class="card-header">
                <h3 class="card-title">All District</h3>

              </div>
              <!-- /.card-header -->
              <div class="card-body">
               <a href="{{route('districts.create')}}" class="btn btn-primary add-new">Add New</a><br><br>

               <div class="card">
                  <div class="card-body">
                      <div class="form-group">
                          <label for="filter-district-division"><strong>Filter by division :</strong></label>
                          <select id="filter-district-division" class="form-control select2bs4">
                              <option value="" disabled="" selected="">Select Divison</option>
                              @foreach(divisions() as $division)
                              <option value="{{$division->id}}">{{$division->name}}</option>
                              @endforeach
                          </select>
                      </div>
                  </div>
              </div>
              	
              	<div class="fetch-data table-responsive">
              	  <table class="table table-bordered table-striped vendor-table data-table" id="district_table">
                  <thead>
                    <tr>
                      <th>District</th>
                      <th>Division</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody class="conts">
                  
                  </tbody>


              	</div>
                

              </div>
              
            </div>
    </section>
 </div>

 

@endsection