@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Add Thana</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Add Thana</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Add Thana</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('thanas.store')}}" method="POST" enctype="multipart/form-data">
              	@csrf
                <div class="card-body">

                <div class="form-group">
                  <label for="thana">Thana Name <span class="required">*</span></label>
                  <input type="text" name="thana" class="form-control" id="thana" placeholder="Thana Name" value="{{old('thana')}}" required="">
                  @error('thana')
		                 <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                     
                </div>

                <div class="form-group">
                  <label for="division_id">Select Division <span class="required">*</span></label>
                  <select class="form-control select2bs4" name="division_id" id="division_id" required="">
                      <option value="" selected="" disabled="">Select Division</option>
                      @foreach(divisions() as $division)
                      <option value="{{$division->id}}">{{$division->name}}</option>
                      @endforeach
                  </select>
                  @error('division_id')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div> 


                <div class="form-group">
                  <label for="district_id">Select District <span class="required">*</span></label>
                  <select class="form-control select2bs4" name="district_id" id="district_id" required="">
                      <option value="" selected="" disabled="">Select District</option>
                    
                  </select>
                  @error('district_id')
                     <span class="alert alert-danger">{{ $message }}</span>
                  @enderror
                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>

                </div>

                  
                </div>
                <!-- /.card-body -->

                
              </form>
            </div>
    </section>
 </div>
@endsection