@extends('admin_master')
@section('content')
 
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">All Thana</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">All Thana</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card">
              <div class="card-header">
                <h3 class="card-title">All Thana</h3>

              </div>
              <!-- /.card-header -->
              <div class="card-body">
               <a href="{{route('thanas.create')}}" class="btn btn-primary add-new">Add New</a><br><br>

               <div class="card">
                  <div class="card-body">
                      <div class="row">
                        <div class="col-md-6">
                          <div class="form-group"> 
                            <label for="filter-thana-division-id"><strong>Filter by division :</strong></label>
                            <select id="filter-thana-division-id" class="form-control select2bs4">
                                <option value="" disabled="" selected="">Select Divison</option>
                                @foreach(divisions() as $division)
                                <option value="{{$division->id}}">{{$division->name}}</option>
                                @endforeach
                            </select>
                          </div>
                        </div>


                        <div class="col-md-6">
                          <div class="form-group"> 
                            <label for="filter-thana-district-id"><strong>Filter by district :</strong></label>
                            <select id="filter-thana-district-id" class="form-control select2bs4">
                                <option value="" disabled="" selected="">Select district</option>
                                
                            </select>
                          </div>
                        </div>

                        <div class="col-md-12">
                          <div class="form-group">
                            <button type="button" class="btn btn-primary btn-block filter-district-button"><i class="fa fa-search"></i> Search</button>
                          </div>
                        </div>

                      </div>
                  </div>
              </div>
              	
              	<div class="fetch-data table-responsive">
              	  <table class="table table-bordered table-striped vendor-table data-table" id="thana_table">
                  <thead>
                    <tr>
                      <th>Thana</th>
                      <th>District</th>
                      <th>Division</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody class="conts">
                  
                  </tbody>


              	</div>
                

              </div>
              
            </div>
    </section>
 </div>
 
 

@endsection