@extends('admin_master')
@section('content')
 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Edit Vendor</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{URL::to('/dashboard')}}">Dashboard</a></li>
              <li class="breadcrumb-item active">Edit Vendor</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <section class="content">
    	<div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Update Vendor</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form action="{{route('users.update',$vendor->id)}}" method="POST" enctype="multipart/form-data">
              	@csrf
                @method('PATCH')
                <div class="card-body">
                  
                  <div class="row">

                    <div class="col-md-4">
                      <div class="form-group">
                      	<label for="name">Name <span class="required">*</span></label>
                      	<input type="text" name="name" class="form-control" id="name" placeholder="Name" required="" value="{{old('name',$vendor->name)}}">
                      	 @error('name')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>

                    <div class="col-md-4">
                      <div class="form-group">
                      	<label for="email">Email <span class="required">*</span></label>
                      	<input type="email" name="email" class="form-control" id="email" placeholder="Email" required="" value="{{old('email',$vendor->email)}}">
                      	@error('email')
		                       <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>

                    <div class="col-md-4">
                      <div class="form-group">
                      	<label for="phone">Phone <span class="required">*</span></label>
                      	<input type="number" name="phone" class="form-control" id="phone" placeholder="Phone" required="" value="{{old('phone', $vendor->phone)}}">
                      	@error('phone')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                      </div>
                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
                       	 <label for="division_id">Select Division <span class="required">*</span></label>
                       	 <select class="form-control select2bs4" id="division_id" name="division_id" required="">
                       	 	<option value="" selected="" disabled="">Select Division</option>
                       	 	@foreach(divisions() as $division)
                       	 	  <option value="{{$division->id}}" <?php if($vendor->division_id == $division->id){echo "selected";} ?>>{{$division->name}}</option>
                       	 	@endforeach
                       	 </select>
                       	 @error('division_id')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                       </div>
                    </div>

                    <div class="col-md-6">
                       <div class="form-group">
                       	 <label for="district_id">Select District <span class="required">*</span></label>
                       	 <select class="form-control select2bs4" name="district_id" id="district_id">
                       	 	<option value="" selected="" disabled="">Select District</option>
                          @foreach(districts($vendor->division_id) as $district)
                            <option value="{{$district->id}}" <?php if($vendor->district_id == $district->id){echo "selected";} ?>>{{$district->name}}</option>
                          @endforeach
                       	 </select>
                       	 @error('district_id')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                       </div>
                    </div>


                    <div class="col-md-8">
                      <div class="form-group">
                      	<label for="address">Full Address <span class="required">*</span></label>
	                      <input type="text" name="address" id="address" class="form-control" placeholder="Full Addres" value="{{old('address', $vendor->address)}}"> 
	                      @error('address')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                      </div>
                      
                    </div>

                    <div class="col-md-4">
                       <div class="form-group">
                       	  <label for="postal_code">Postal Code <span class="required">*</span></label>
                       	  <input type="number" class="form-control" name="postal_code" id="postal_code" placeholder="Postal Code" required="" value="{{old('postal_code', $vendor->postal_code)}}">
                       	   @error('postal_code')
		                 <span class="alert alert-danger">{{ $message }}</span>
                        @enderror
                       </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="lat">Latitude</label>
                        <input type="text" name="lat" id="lat" class="form-control lat" value="{{$vendor->lat}}" placeholder="Latitude" required="">
                      </div>
                    </div>


                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="lon">Longitude</label>
                        <input type="text" name="lon" class="form-control lon" placeholder="Longitude" id="lon" value="{{$vendor->lon}}" required="">
                      </div>
                    </div>

                </div>

                <div class="form-group">
                  <button type="submit" class="btn btn-success">Update</button>
                </div>
                  
                </div>
                <!-- /.card-body -->
              </form>
            </div>
    </section>
 </div>
@endsection