<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\ApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('register', [AuthController::class, 'register']); 
Route::post('login', [AuthController::class, 'login']);

Route::post('delivermen-register', [AuthController::class, 'delivermenRegister']);
Route::post('delivermen-login', [AuthController::class, 'deliverymenLogin']);

//area
Route::get('divisions', [ApiController::class, 'divisions']);
Route::get('/cities/{district_id}', [ApiController::class, 'cities']);
Route::get('/districts/{division_id}', [ApiController::class, 'districts']);
Route::get('/thanas/{district_id}', [ApiController::class, 'thanas']);

//nearest location
Route::post('nearest-deliverymen', [ApiController::class, 'nearestDeliverymen']);

//nearest vendors
 Route::post('vendor-lists', [ApiController::class, 'vendorLists']);
 
 Route::post('vendor-update', [ApiController::class, 'vendorUpdate']);


//check otp
Route::post('check-otp', [ApiController::class, 'checkOtp']);

//deliverymen status
Route::post('deliverymen-status', [ApiController::class, 'deliverymenStatus']);

Route::post('send-user-push', [ApiController::class, 'sendUserPush']);

Route::get('/deliverymen-info/{user_id}', [ApiController::class, 'deliverymenInfo']);


Route::post('cancel-order', [ApiController::class, 'cancelOrder']);

Route::get('/get-brands/{id}', [ApiController::class, 'getBrands']);

 //weeks 
   Route::get('/all-week/{id}', [ApiController::class, 'allWeek']);

   Route::get('/current-week/{id}', [ApiController::class, 'currentWeek']);

Route::middleware('auth:sanctum')->group( function () { 
    //logout
    Route::post('/logout', [AuthController::class, 'logout']);
    
    
    //price calculation
    Route::post('price-calculation', [ApiController::class, 'priceCalculation']);

    //delivermen
    Route::post('set-deliver-zone', [AuthController::class, 'setDeliverXone']);

    Route::get('devlivermen-details', [AuthController::class, 'deliverymenDetails']);

    //user
    Route::get('user-details', [ApiController::class, 'userDetails']);
    
    //slider apis
    Route::get('sliders', [ApiController::class, 'sliders']);

    //orders
    Route::post('create-order', [ApiController::class, 'createOrder']);

   Route::post('order-update', [ApiController::class, 'orderUpdate']);
  
  Route::get('/trip-histories', [ApiController::class, 'tripHistory']);
  
  //weeks 
   Route::get('all-week', [ApiController::class, 'allWeek']);

   Route::post('order-by-date', [ApiController::class, 'orderBydate']);

   Route::post('week-details', [ApiController::class, 'weekDetails']);

   Route::get('/total-due', [ApiController::class, 'totalDue']);
   
   Route::post('send-push', [ApiController::class, 'sendPush']);

   Route::get('/order-details/{id}', [ApiController::class, 'orderDetails']);
   
   Route::post('update-devicetoken', [ApiController::class, 'updateDeviceToken']);
   
 
 Route::post('review', [ApiController::class, 'review']);
 
 Route::get('my-reviews', [ApiController::class, 'myReviews']);
 
 //user profile update
 Route::post('user-profile-edit', [ApiController::class, 'userProfileEdit']);
 
 //change password
 Route::post('change-password', [ApiController::class, 'changePassword']);
 
 
 //latest orders
 Route::get('/recent-orders', [ApiController::class, 'recentOrders']);
 
 //chat

Route::post('store-chat', [ApiController::class, 'storeChat']);


//update-address
Route::post('update-address', [ApiController::class, 'updateAddress']);

//deliverymen profile update
Route::post('delivery-profile-update', [ApiController::class, 'deliveryProfileUpdate']);

//vehicle update

Route::post('delivery-vehicle-update', [ApiController::class, 'vehicleUpdate']);

Route::get('get-total-balance', [ApiController::class, 'getTotalbalance']);



//banks

Route::post('add-user-bank', [ApiController::class, 'addUserbank']);

Route::post('edit-user-bank', [ApiController::class, 'editUserbank']);



Route::get('user-bank-lists', [ApiController::class, 'userBanklists']); 

Route::post('add-withdraw-request', [ApiController::class, 'addWithdrawrequest']);
Route::get('user-withdraw-lists', [ApiController::class, 'userWithdrawlists']);
Route::post('bank-details', [ApiController::class, 'bankDetails']);
});

Route::post('collect-notification', [ApiController::class, 'collectNotification']);

Route::post('collect-notification-user', [ApiController::class, 'collectNotificationuser']);


Route::post('pickup-status-store', [ApiController::class, 'pickupStatusstore']);

Route::post('collectpay-status-store', [ApiController::class, 'collectStatusstore']);


Route::post('get-check-status', [ApiController::class, 'getCheckstatus']);


//get order details
Route::post('get-order-details', [ApiController::class, 'getOrderDetails']);

//resend otp
Route::post('resend-otp', [ApiController::class, 'resendOtp']);



Route::post('chat-lists', [ApiController::class, 'chatLists']);

Route::post('forgot-password', [ApiController::class, 'forgotPassword']);

Route::post('reset-otp', [ApiController::class, 'resetOtp']);

Route::post('reset-password', [ApiController::class, 'resetPassword']);


//inboxes
   Route::get('inboxes', [ApiController::class, 'inboxes']);
   
   //notifications
   Route::get('notifications', [ApiController::class, 'notifications']);

   Route::get('support', [ApiController::class, 'support']);
Route::get('/vehicle-types', [ApiController::class, 'vehicleTypes']);

Route::post('get-order-status', [ApiController::class, 'getOrderStatus']);

//promocodes
Route::get('promocodes', [ApiController::class, 'promocodes']);

//check date
Route::post('check-date', [ApiController::class, 'checkDate']);

//set payment gateway
Route::post('set-payment-gateway', [ApiController::class, 'setPaymentGateway']);

//payment method lists
Route::get('/payment-method-lists', [ApiController::class, 'paymentMethodLists']);

Route::get('/get-timezones', [ApiController::class, 'gettimeZones']);


Route::post('complete-order', [ApiController::class, 'completeOrder']);


//update payment method
Route::post('update-payment-method', [ApiController::class, 'updatePaymentmethod']);

Route::post('after-cancel-order', [ApiController::class, 'afterCancelorder']);