<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\AccessController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\ActionController;
use App\Http\Controllers\SettingConroller;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\PromoCodeController;
use App\Http\Controllers\InboxController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\DivisionController;
use App\Http\Controllers\DistrictController;
use App\Http\Controllers\ThanaController;
use App\Http\Controllers\VehicleTypeController;
use App\Http\Controllers\BrandController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [IndexController::class, 'loginPage']); 

Route::post('admin-login', [AccessController::class, 'adminLogin']);

Route::get('/logout', [AccessController::class, 'Logout']);

 
Route::group(['middleware' => 'prevent-back-history'],function(){
	//admin dashboard

    Route::get('/admin/dashboard', [DashboardController::class, 'Dashboard']);
    
    //sliders
    Route::resource('sliders', SliderController::class);

    //vendors
    Route::resource('users', UserController::class);
   
   Route::get('/decline-vendor/{id}', [ActionController::class, 'declineVendor']);
   Route::get('/active-vendor/{id}', [ActionController::class, 'activeVendor']);

   //divisions
   Route::resource('divisions', DivisionController::class);

   //districts

   Route::resource('districts', DistrictController::class);

   //thanas
   Route::resource('thanas', ThanaController::class);

   //vehicle types
   Route::resource('vehicle-types', VehicleTypeController::class);

   //brands
   Route::resource('brands', BrandController::class);


   //promocodes
    Route::resource('promocodes', PromoCodeController::class);

   //notitfications
    Route::resource('inboxes', InboxController::class);

   //settings
     //city settings
     Route::get('/city-settings', [SettingConroller::class, 'citySettings']);

     Route::post('set-city', [SettingConroller::class, 'setCity']);

   //reports
    Route::get('/daily-report', [ReportController::class, 'dailyReport']);
    Route::get('/monthly-yearly-report', [ReportController::class, 'monthlyYearlyReport']);
    Route::get('/custom-report', [ReportController::class, 'customReport']);
    
    Route::get('my-daily-report', [ReportController::class, 'myDailyReport']);
   
   Route::get('my-monthly-yearly-report', [ReportController::class, 'mymonthlyYearlyReport']);

    Route::get('/my-custom-report', [ReportController::class, 'mycustomReport']);

    Route::get('/withdraw-report', [ReportController::class, 'withdrawReport']);



    //settings
    Route::get('/account-settings', [SettingConroller::class, 'accountSettings']);
    Route::get('/payment-settings', [SettingConroller::class, 'paymentSetting']);
    Route::post('settings-account', [SettingConroller::class, 'settingsAccount']);
    Route::get('/change-password', [SettingConroller::class, 'changePassword']);
    Route::post('password-change', [SettingConroller::class, 'passwordChange']);
    Route::get('/payment-decline/{id}', [SettingConroller::class, 'paymentDecline']);
    Route::get('/payment-active/{id}', [SettingConroller::class, 'paymentActive']);
    Route::get('/payment-show/{id}', [SettingConroller::class, 'paymentShow']);
    Route::get('payment-info-update', [SettingConroller::class, 'paymentInfoUpdate']);
    Route::get('/price-settings', [SettingConroller::class, 'priceSetting']);
    Route::post('set-price', [SettingConroller::class, 'setPrice']);
    Route::get('/mail-settings', [SettingConroller::class, 'mailSettings']);
    Route::post('settings-mail', [SettingConroller::class, 'settingsMail']);
    Route::get('/firebase-settings', [SettingConroller::class, 'firebaseSetting']);
    Route::post('settings-firebase', [SettingConroller::class, 'settingsFirebase']);
    Route::get('/project-settings', [SettingConroller::class, 'projectSettings']);
    Route::post('settings-project', [SettingConroller::class, 'settingsProject']);

     Route::get('/set-vendor/{id}', [SettingConroller::class, 'setVendor']);
    
     Route::post('vendor-set', [SettingConroller::class, 'vendorSet']);

});

//installation
Route::get('/install', [InstallController::class, 'install']);
Route::post('store-info', [InstallController::class, 'storeInfo']);
Route::get('/admin-register', [InstallController::class, 'register']);
Route::post('register-admin', [InstallController::class, 'registerAdmin']);

//ajax requests
Route::get('/get-city/{id}', [AjaxController::class, 'getCity']);
Route::get('/get-district/{id}', [AjaxController::class, 'getDistrict']);
Route::get('/get-thanas', [AjaxController::class, 'getThanas']);
Route::get('/get-order/{id}', [AjaxController::class, 'getOrder']);
Route::get('/decline-withdraw/{id}', [AjaxController::class, 'declineWithdraw']);
Route::get('/active-withdraw/{id}', [AjaxController::class, 'activeWithdraw']);
//ordering
Route::get('/update-change-status/{id}', [AjaxController::class, 'updateChangeStatus']); 

