<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Admin | Dashboard</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>">
  <!-- JQVMap -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/jqvmap/jqvmap.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('back/dist/css/adminlte.min.css')); ?>">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/overlayScrollbars/css/OverlayScrollbars.min.css')); ?>">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/daterangepicker/daterangepicker.css')); ?>">
  <!-- summernote -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/summernote/summernote-bs4.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('custom/style.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('custom/toastr.css')); ?>">


  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/select2/css/select2.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('custom/ionicons.min.css')); ?>">

     <!-- Data Table Css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('back/datatable/css/dataTables.bootstrap4.min.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('back/datatable/css/buttons.dataTables.min.css')); ?>">
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('back/datatable/css/responsive.bootstrap4.min.css')); ?>">
 
    <link rel="stylesheet" href="<?php echo e(asset('dropify/dist/css/dropify.min.css')); ?>">

</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">



  <!-- Navbar -->
  <nav  class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
     
      <li class="nav-item">

        <div class="dropdown show">
                        <a class="text-decoration-none text-white" href="#" role="button" id="dropdownMenuLink"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php if(Auth::user()->image == NULL): ?>
                            <img src="<?php echo e(asset('back/dist/img/user2-160x160.jpg')); ?>" alt="Admin" height="30" width="30" class="brand-image img-circle elevation-3">&nbsp;&nbsp;Admin
                            <?php else: ?>
                              <img src="<?php echo e(URL::to(Auth::user()->image)); ?>" alt="Admin" height="30" width="30" class="brand-image img-circle elevation-3">&nbsp;&nbsp;Admin
                            <?php endif; ?>
                        </a>

                        <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <a class="dropdown-item" href="<?php echo e(URL::to('/logout')); ?>">Logout</a>
                        </div>
                    </div>
      </li>
    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-light-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(URL::to('/dashboard')); ?>" class="brand-link">
      <img src="<?php echo e(URL::to(project()->project_logo)); ?>" alt="Admin" class="brand-image img-circle elevation-3">
      <span class="brand-text font-weight-light"><?php echo e(project()->project_name); ?></span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user panel (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <?php if(Auth::user()->image == NULL): ?>
          <img src="<?php echo e(asset('back/dist/img/user2-160x160.jpg')); ?>" class="img-circle elevation-2" alt="User Image">

         <?php else: ?>
           <img src="<?php echo e(URL::to(Auth::user()->image)); ?>" class="img-circle elevation-2" alt="User Image">
         <?php endif; ?>
        </div>
        <div class="info">
          <a href="#" class="d-block"><?php echo e(Auth::user()->name); ?></a>
        </div>
      </div>


      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
 
          <li class="nav-item">
            <a href="<?php echo e(URL::to('/dashboard')); ?>" class="nav-link">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
                
              </p>
            </a>
          </li>
         <?php if(Auth::user()->role == 'admin'): ?>
          <li class="nav-item">
            <a href="<?php echo e(URL::to('sliders')); ?>" class="nav-link">
             <i class="nav-icon fas fa-book"></i>
              <p>
                Sliders
                
              </p>
            </a>
          </li>
      <?php endif; ?>

        <?php if(Auth::user()->role == 'admin'): ?>
          <li class="nav-item">
            <a href="<?php echo e(route('users.create')); ?>" class="nav-link">
              <i class="nav-icon fas fa-users"></i>
              <p>
                Vendors
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(route('users.create')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Add Vendor</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('users')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>All Vendor</p>
                </a>
              </li>

            </ul>
          </li>
      <?php endif; ?>

      <?php if(Auth::user()->role == 'admin'): ?>

          <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-list"></i>
              <p>
                Promocodes
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(route('promocodes.create')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i> 
                  <p>Add Promocode</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(route('promocodes.index')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>All Promocode</p>
                </a>
              </li>



            </ul>
          </li>

        <?php endif; ?>

        <?php if(Auth::user()->role == 'admin'): ?>
        <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-city"></i>
              <p>
                Set Zone
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(URL::to('divisions')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i> 
                  <p>Divisions</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/districts')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Districts</p>
                </a>
              </li>

              <li class="nav-item">
                <a href="<?php echo e(URL::to('/thanas')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Thana</p>
                </a>
              </li>


            </ul>
          </li>
      <?php endif; ?>

        <?php if(Auth::user()->role == 'admin'): ?>

          <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-bell"></i>
              <p>
                Notification
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(route('inboxes.create')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>  
                  <p>Add Notification</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(route('inboxes.index')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>All Notification</p>
                </a>
              </li>



            </ul>
          </li>

        <?php endif; ?>


        <?php if(Auth::user()->role == 'admin'): ?>


          <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-car"></i>
              <p>
                Vehicle
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(url('vehicle-types')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Vehicle Types</p>
                </a>
              </li>
          


              <li class="nav-item">
                <a href="<?php echo e(url('brands')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Brands</p>
                </a>
              </li>


            </ul>
          </li>
          
          <?php endif; ?>

        <?php if(Auth::user()->role == 'admin'): ?>


          <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-book"></i>
              <p>
                Report
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/daily-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Daily Report</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('monthly-yearly-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Monthly & Yearly Report</p>
                </a>
              </li>


              <li class="nav-item">
                <a href="<?php echo e(URL::to('custom-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Custom Report</p>
                </a>
              </li>


              <li class="nav-item">
                <a href="<?php echo e(URL::to('withdraw-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Withdraw Requests</p>
                </a>
              </li>


            </ul>
          </li>
          
          <?php endif; ?>

          <?php if(Auth::user()->role == 'vendor'): ?>
          
          <li class="nav-item">
            <a href="" class="nav-link">
              <i class="nav-icon fas fa-book"></i>
              <p>
                My Report
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/my-daily-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Daily Report</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('my-monthly-yearly-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Monthly & Yearly Report</p>
                </a>
              </li>


              <li class="nav-item">
                <a href="<?php echo e(URL::to('my-custom-report')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Custom Report</p>
                </a>
              </li>


            </ul>
          </li>
          
          <?php endif; ?>



         <li class="nav-item">
            <a href="<?php echo e(route('users.create')); ?>" class="nav-link">
              <i class="nav-icon fas fa-cog"></i>
              <p>
                Settings
                <i class="fas fa-angle-left right"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <?php if(Auth::user()->role == 'admin'): ?>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/mail-settings')); ?>" class="nav-link" id="app-settings">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Mail Settings</p>
                </a>
              </li>
              <?php endif; ?>

              <?php if(Auth::user()->role == 'admin'): ?>

              <li class="nav-item">
                <a href="<?php echo e(URL::to('/firebase-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Firebase Settings</p>
                </a>
              </li>

           <?php endif; ?>

              <?php if(Auth::user()->role == 'admin'): ?>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/city-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>City Settings</p>
                </a>
              </li>

            <?php endif; ?>

            <?php if(Auth::user()->role == 'admin'): ?>

              <li class="nav-item">
                <a href="<?php echo e(URL::to('/price-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Price Settings</p>
                </a>
              </li>

           <?php endif; ?>

       <?php if(Auth::user()->role == 'admin'): ?>
           <li class="nav-item">
                <a href="<?php echo e(URL::to('/payment-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Payment Settings</p>
                </a>
              </li>
         <?php endif; ?>

              <li class="nav-item">
                <a href="<?php echo e(URL::to('/change-password')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Change Password</p>
                </a>
              </li>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/account-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Account Settings</p>
                </a>
              </li>

            <?php if(Auth::user()->role == 'admin'): ?>
              <li class="nav-item">
                <a href="<?php echo e(URL::to('/project-settings')); ?>" class="nav-link">
                  <i class="far fa-circle nav-icon"></i>
                  <p>Project Settings</p>
                </a>
              </li>
              <?php endif; ?>

            </ul>
          </li>

        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <?php echo $__env->yieldContent('content'); ?>


  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?php echo e(asset('custom/custom_js.js')); ?>"></script>
<!-- jQuery UI 1.11.4 -->
<script src="<?php echo e(asset('back/plugins/jquery-ui/jquery-ui.min.js')); ?>"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->

<!-- data-table js -->
<script src="<?php echo e(asset('back/datatable/js/jquery.dataTables.min.js')); ?>"></script>

<script src="<?php echo e(asset('back/datatable/js/dataTables.buttons.min.js')); ?>"></script>



<script src="<?php echo e(asset('back/datatable/js/dataTables.bootstrap4.min.js')); ?>"></script>

<script src="<?php echo e(asset('back/datatable/js/dataTables.responsive.min.js')); ?>"></script>

<script src="<?php echo e(asset('back/datatable/js/responsive.bootstrap4.min.js')); ?>"></script>

<script src="<?php echo e(asset('back/datatable/js/data-table-custom.js')); ?>"></script>


<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('back/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

<!-- daterangepicker -->
<script src="<?php echo e(asset('back/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('back/plugins/daterangepicker/daterangepicker.js')); ?>"></script>

<!-- Tempusdominus Bootstrap 4 -->
<script src="<?php echo e(asset('back/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>
<!-- Summernote -->
<script src="<?php echo e(asset('back/plugins/summernote/summernote-bs4.min.js')); ?>"></script>
<!-- overlayScrollbars -->
<script src="<?php echo e(asset('back/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('back/dist/js/adminlte.js')); ?>"></script>

<script src="<?php echo e(asset('back/dist/js/pages/dashboard.js')); ?>"></script>

<!-- Select2 -->
<script src="<?php echo e(asset('back/plugins/select2/js/select2.full.min.js')); ?>"></script>

<script src="<?php echo e(asset('custom/custom.js')); ?>"></script>
<?php if(pathValue() == 1): ?>
<script src="<?php echo e(asset('custom/datepicker.js')); ?>"></script>
<?php endif; ?>
<script>
  $(function () {
    // Summernote
    $('#summernote').summernote();

    var base_url = "<?php echo e(url('/')); ?>";
    localStorage.setItem('base_url', base_url);
 
  })
</script>

<script src="<?php echo e(asset('custom/toastr.js')); ?>"></script>
 
  <?php if(Session::has('messege')): ?>
    <script>
                    toastr.<?php echo e(Session::get('alert-type')); ?>("<?php echo e(Session::get('messege')); ?>")
                 </script>
  <?php endif; ?>
<script src="<?php echo e(asset('dropify/dist/js/dropify.min.js')); ?>"></script>

<script>
  $('.dropify').dropify();
</script>


</body>
</html>
<?php /**PATH D:\lw-xampp\htdocs\complete_courier_backend\resources\views/admin_master.blade.php ENDPATH**/ ?>