<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Backend Install</title>
    <link href="<?php echo e(asset('custom/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/select2/css/select2.min.css')); ?>">

  <link rel="stylesheet" href="<?php echo e(asset('back/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">

  </head>
  <body>
    

    <div class="container mt-5">
      <div class="card">
      	<div class="card-header">
      	   <h5 class="text-center">Project Details</h5>
      	</div>

      	<div class="card-body">
      	  <form class="" action="<?php echo e(url('store-info')); ?>" method="POST">
                  <?php echo csrf_field(); ?>

 
                  <div class="row mb-3">
                    <label for="domain_url" class="col-sm-2 col-form-label">Your Domain URL</label>
                    <div class="col-sm-12">
                      <input type="url" name="domain_url" class="form-control" id="domain_url" placeholder="Example: http://yourdomain.com" required="">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <label for="timezone" class="col-sm-2 col-form-label">Select Timezone</label>
                    <div class="col-sm-12">
                      <select id="timezone" name="timezone" class="form-control select2bs4" required="">
                            <option value="" selected="" disabled="">Select Timezone</option>
                            <?php $__currentLoopData = timezones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <option value="<?php echo e($timezone); ?>"><?php echo e($timezone); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>
                  </div> 


                  <div class="row mb-3">
                    <label for="db_name" class="col-sm-2 col-form-label">Database Name</label>
                    <div class="col-sm-12">
                      <input type="text" name="db_name" class="form-control" id="db_name" placeholder="Database Name" required="">
                    </div>
                  </div>

                  <div class="row mb-3">
                    <label for="db_user" class="col-sm-2 col-form-label">Database User Name</label>
                    <div class="col-sm-12">
                      <input type="text" name="db_user" class="form-control" id="db_user" placeholder="Database User Name" required="">
                    </div>
                  </div>


                  <div class="row mb-3">
                    <label for="db_password" class="col-sm-2 col-form-label">Database Password</label>
                    <div class="col-sm-12">
                      <input type="password" name="db_password" class="form-control" id="db_password" placeholder="Database Password">
                    </div>
                  </div>

 
                  
                  <div class="row mb-3">
                    <div class="col-sm-12 text-center">
                      <button type="submit" class="btn btn-primary">Next Step </button>
                    </div>
                  </div>

                </form><!-- End General Form Elements -->

      	</div>
      </div>
    </div>
    

    <script src="<?php echo e(asset('custom/custom_js.js')); ?>"></script>

    <!-- Select2 -->
    <script src="<?php echo e(asset('back/plugins/select2/js/select2.full.min.js')); ?>"></script>

    <script src="<?php echo e(asset('custom/select2.js')); ?>"></script> 

  </body>
</html><?php /**PATH E:\php-laravel-11\htdocs\complete_courier_backend\resources\views/install/create_project.blade.php ENDPATH**/ ?>